﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

class ICheckModule;

class ModuleSelector
{
public:
    ModuleSelector() NN_NOEXCEPT;
    ~ModuleSelector() NN_NOEXCEPT;

    ICheckModule* Select(ICheckModule* pCheckModuleList[], int moduleNum) NN_NOEXCEPT;

private:
    void ResetFlags(ICheckModule* pModule) NN_NOEXCEPT;
    void PrintItem(ICheckModule* pModule, int index, int flagIndex) NN_NOEXCEPT;
    void PrintMenu(ICheckModule* pCheckModuleList[], int moduleNum) NN_NOEXCEPT;
    void PrintSelectedItem(ICheckModule* pCheckModuleList[], int selectedNo, int flagIndex) NN_NOEXCEPT;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    void UpdateDraw(ICheckModule* pCheckModuleList[], int moduleNum, int selectedNo) NN_NOEXCEPT;
#endif
};
