﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>

struct FlagElement
{
    static const int FlagNameMax = 64;
    char flagName[FlagNameMax];
    bool enabled;
};

class FlagList
{
public:
    FlagList(FlagElement* pFlagElementList, int flagCount) NN_NOEXCEPT;

    const char* GetFlagName(int index) const NN_NOEXCEPT;
    void SetFlagEnabled(int index, bool enabled) NN_NOEXCEPT;
    bool IsFlagEnabled(int index) const NN_NOEXCEPT;
    int GetFlagCount() const NN_NOEXCEPT;
    void ShowFlags(int selectedFlagIndex, bool isHorizontal) NN_NOEXCEPT;

private:
    FlagElement* m_pFlagElementList;
    int m_FlagCount;
};

enum GlobalFlagType
{
    GlobalFlagType_UseMemorySoundArchive,                                   //< メモリサウンドアーカイブに変更するか
    GlobalFlagType_UseStreamCache,                                          //< ストリームキャッシュを使うか
    GlobalFlagType_SoundSystemUsingApplicationMemoryPool,                   //< SoundSystem のメモリプール管理をアプリケーション側で行うか
    GlobalFlagType_SoundSystemUsingApplicationCircularBufferSinkBuffer,     //< CBS 用バッファのメモリプール管理をアプリケーション側で行うか
    GlobalFlagType_EnableSoundArchivePlayerAppliedStreamInstanceBuffer,     //< StreamSound のインスタンスバッファをアプリケーション側で用意するか
    GlobalFlagType_DisableSoundThread,                                      //< サウンドスレッドを無効化するか
    GlobalFlagType_EnableSpy,                                               //< Spy を有効化するか
    GlobalFlagType_EnableCpuProfiler,                                       //< CpuProfiler を有効化するか（実機版のみ、PC 版はこのフラグが無視される）
};

void AttachGlobalFlagList(FlagList* pFlagList) NN_NOEXCEPT;
void DetachGlobalFlagList() NN_NOEXCEPT;
FlagList& GetGlobalFlagList() NN_NOEXCEPT;
