﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "FlagList.h"

namespace
{
    FlagList* g_pGlobalFlagList;
}

FlagList::FlagList(FlagElement* pFlagElementList, int flagCount) NN_NOEXCEPT
: m_pFlagElementList(pFlagElementList)
, m_FlagCount(flagCount)
{
}

const char* FlagList::GetFlagName(int index) const NN_NOEXCEPT
{
    if (m_pFlagElementList == nullptr)
    {
        return "Nothing";
    }

    return m_pFlagElementList[index].flagName;
}

void FlagList::SetFlagEnabled(int index, bool enabled) NN_NOEXCEPT
{
    if (m_pFlagElementList == nullptr)
    {
        return;
    }

    m_pFlagElementList[index].enabled = enabled;
}

bool FlagList::IsFlagEnabled(int index) const NN_NOEXCEPT
{
    if (m_pFlagElementList == nullptr)
    {
        return false;
    }

    return m_pFlagElementList[index].enabled;
}

int FlagList::GetFlagCount() const NN_NOEXCEPT
{
    if (m_pFlagElementList == nullptr)
    {
        return 0;
    }

    return m_FlagCount;
}

void FlagList::ShowFlags(int selectedFlagIndex, bool isHorizontal) NN_NOEXCEPT
{
    for (auto i = 0; i < GetFlagCount(); ++i)
    {
        NN_LOG("%s[%s]%s",
            i == selectedFlagIndex ? " >>" : "   ",
            IsFlagEnabled(i) ? "*" : " ",
            GetFlagName(i));
        if (!isHorizontal)
        {
            NN_LOG("\n");
        }
    }
    if (isHorizontal)
    {
        NN_LOG("\n");
    }
}

void AttachGlobalFlagList(FlagList* pFlagList) NN_NOEXCEPT
{
    g_pGlobalFlagList = pFlagList;
}

void DetachGlobalFlagList() NN_NOEXCEPT
{
    g_pGlobalFlagList = nullptr;
}

FlagList& GetGlobalFlagList() NN_NOEXCEPT
{
    return *g_pGlobalFlagList;
}
