﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Surround.h"

#include "../FlagList.h"
#include "../GfxCode/DebugViewer.h"

namespace
{
    FlagList g_LocalFlagList(nullptr, 0);
}

void SurroundCheckModule::OnInitializeAtk() NN_NOEXCEPT
{
    m_CommonObject.Initialize();

    nn::atk::SoundSystem::SetOutputMode(nn::atk::OutputMode_Surround);
    m_SurroundPanValue = 1.0f;
}

void SurroundCheckModule::OnFinalizeAtk() NN_NOEXCEPT
{
    m_CommonObject.Finalize();
}

void SurroundCheckModule::OnLoadData() NN_NOEXCEPT
{
    m_CommonObject.LoadData();
}

void SurroundCheckModule::OnPrintUsage() NN_NOEXCEPT
{
    m_CommonObject.PrintUsage();

    NN_LOG("[Left]         SurroundPan Value Down\n");
    NN_LOG("[Right]        SurroundPan Value Up\n");
}

void SurroundCheckModule::OnUpdateInput() NN_NOEXCEPT
{
    m_CommonObject.UpdateInput();

    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Right >() )
    {
        m_SurroundPanValue += 0.1f;
        if ( m_SurroundPanValue > 2.0f )
        {
            m_SurroundPanValue = 2.0f;
        }

        m_CommonObject.GetSoundHandle().SetSurroundPan(m_SurroundPanValue);
        NN_LOG("SurroundPan = %lf\n", m_SurroundPanValue);
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Left >() )
    {
        m_SurroundPanValue -= 0.1f;
        if ( m_SurroundPanValue < 0.0f )
        {
            m_SurroundPanValue = 0.0f;
        }

        m_CommonObject.GetSoundHandle().SetSurroundPan(m_SurroundPanValue);
        NN_LOG("SurroundPan = %lf\n", m_SurroundPanValue);
    }
}

void SurroundCheckModule::OnUpdateAtk() NN_NOEXCEPT
{
    m_CommonObject.Update();
}

#if defined( NN_ATK_ENABLE_GFX_VIEWING )
void SurroundCheckModule::OnUpdateDraw() NN_NOEXCEPT
{
    m_CommonObject.UpdateDraw(GetModuleName());
}
#endif

FlagList& SurroundCheckModule::GetLocalFlagList() NN_NOEXCEPT
{
    return g_LocalFlagList;
}
