﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SinglePlay.h"

#include "../FlagList.h"
#include "../GfxCode/DebugViewer.h"

namespace
{
    FlagList g_LocalFlagList(nullptr, 0);
}

void SinglePlayCheckModule::OnInitializeAtk() NN_NOEXCEPT
{
    m_CommonObject.Initialize();
}

void SinglePlayCheckModule::OnFinalizeAtk() NN_NOEXCEPT
{
    m_CommonObject.Finalize();
}

void SinglePlayCheckModule::OnLoadData() NN_NOEXCEPT
{
    m_CommonObject.LoadData();

    bool isSuccess;
    nn::atk::SoundDataManager& soundDataManager = m_CommonObject.GetSoundDataManager();
    nn::atk::SoundHeap& soundHeap = m_CommonObject.GetSoundHeap();

    isSuccess = soundDataManager.LoadData( WSD_WIHAHO_NEWEST, &soundHeap );
    NN_ABORT_UNLESS( isSuccess, "LoadData(WSD_WIHAHO_NEWEST) failed." );
    isSuccess = soundDataManager.LoadData( WSD_WIHAHO_NEWEST_DURATION, &soundHeap );
    NN_ABORT_UNLESS( isSuccess, "LoadData(WSD_WIHAHO_NEWEST_DURATION) failed." );
    isSuccess = soundDataManager.LoadData( WSD_WIHAHO_OLDEST, &soundHeap );
    NN_ABORT_UNLESS( isSuccess, "LoadData(WSD_WIHAHO_OLDEST) failed." );
    isSuccess = soundDataManager.LoadData( WSD_WIHAHO_OLDEST_DURATION, &soundHeap );
    NN_ABORT_UNLESS( isSuccess, "LoadData(WSD_WIHAHO_OLDEST_DURATION) failed." );
}

void SinglePlayCheckModule::OnPrintUsage() NN_NOEXCEPT
{
    m_CommonObject.PrintUsage();

    NN_LOG("[Up]           StartSound WSD  (WSD_WIHAHO_NEWEST)\n");
    NN_LOG("[Left]         StartSound WSD  (WSD_WIHAHO_NEWEST_DURATION)\n");
    NN_LOG("[Down]         StartSound WSD  (WSD_WIHAHO_OLDEST)\n");
    NN_LOG("[Right]        StartSound WSD  (WSD_WIHAHO_OLDEST_DURATION)\n");
}

void SinglePlayCheckModule::OnUpdateInput() NN_NOEXCEPT
{
    m_CommonObject.UpdateInput();

    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Up >() )
    {
        CommonObject::StartParam startParam;
        startParam.isSoundStopEnabled = false;
        m_CommonObject.PlayWithStartSound(WSD_WIHAHO_NEWEST, "WSD_WIHAHO_NEWEST", startParam);
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Left >() )
    {
        CommonObject::StartParam startParam;
        startParam.isSoundStopEnabled = false;
        m_CommonObject.PlayWithStartSound(WSD_WIHAHO_NEWEST_DURATION, "WSD_WIHAHO_NEWEST_DURATION", startParam);
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Down >() )
    {
        CommonObject::StartParam startParam;
        startParam.isSoundStopEnabled = false;
        m_CommonObject.PlayWithStartSound(WSD_WIHAHO_OLDEST, "WSD_WIHAHO_OLDEST", startParam);
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Right >() )
    {
        CommonObject::StartParam startParam;
        startParam.isSoundStopEnabled = false;
        m_CommonObject.PlayWithStartSound(WSD_WIHAHO_OLDEST_DURATION, "WSD_WIHAHO_OLDEST_DURATION", startParam);
    }
}

void SinglePlayCheckModule::OnUpdateAtk() NN_NOEXCEPT
{
    m_CommonObject.Update();
}

#if defined( NN_ATK_ENABLE_GFX_VIEWING )
void SinglePlayCheckModule::OnUpdateDraw() NN_NOEXCEPT
{
    m_CommonObject.UpdateDraw(GetModuleName());
}
#endif

FlagList& SinglePlayCheckModule::GetLocalFlagList() NN_NOEXCEPT
{
    return g_LocalFlagList;
}
