﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "../SoundRecorder.h"
#include "ICheckModule.h"

class MixModeCheckModule : public ICheckModule
{
private:
    class CommonObjectForMixMode : public CommonObject
    {
    public:
        CommonObjectForMixMode() : m_pOwner(nullptr) {}
        virtual void OnPostStartSound() NN_NOEXCEPT NN_OVERRIDE;

        void SetOwner(MixModeCheckModule* pOwner)
        {
            m_pOwner = pOwner;
        }

    private:
        MixModeCheckModule* m_pOwner;
    };

public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "MixMode";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

    void SetMixVolume() NN_NOEXCEPT;
    void FadeAuxBusVolume() NN_NOEXCEPT;

private:
    CommonObjectForMixMode m_CommonObject;

    int m_MixChannel;
    nn::atk::MixVolume m_MixVolume;

    // TODO: マルチトラックストリームのテスト
    //nn::atk::MixVolume m_MixStreamTrackPiano;
    //nn::atk::MixVolume m_MixStreamTrackDrum;

    // TODO: マルチトラックシーケンスのテスト
    //nn::atk::MixVolume m_MixSequenceTrack1;
    //nn::atk::MixVolume m_MixSequenceTrack2;
    //nn::atk::MixVolume m_MixSequenceTrack3;

    SoundRecorder m_Recorder;
    void* m_RecorderStackBuffer;
    void* m_RecorderBuffer;

    bool m_IsAuxBusFadedOut;

    nn::atk::EffectDelay m_Delay;
    void* m_DelayBuffer;

    nn::atk::EffectReverb m_Reverb;
    void* m_ReverbBuffer;

    UserEffectAux m_UserEffectAux;
    void* m_UserEffectAuxBuffer;
};
