﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>
#include <nn/spy.h>
#include <nn/spy/atk/spy_AtkSpyModule.h>

//! @brief  atk に関連するのプロファイリングを行います
class AtkProfiler
{
public:
    //! @brief  必要なバッファサイズを計算します
    size_t GetRequiredMemorySize(int taskProfileCount, int soundThreadUpdateProfileCount) NN_NOEXCEPT;
    //! @brief  初期化します
    void Initialize(void* buffer, size_t bufferSize, int taskProfileCount, int soundThreadUpdateProfileCount) NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  表示処理をします
    void Show(nn::atk::SoundHandle& soundHandle) NN_NOEXCEPT;

    int UpdateInput() NN_NOEXCEPT;
    void PrintUsage() NN_NOEXCEPT;

    bool IsProfileReaderEnabled() const NN_NOEXCEPT;
    void SetProfileReaderEnabled(bool isEnabled) NN_NOEXCEPT;
    bool IsUsingThreadInfoRecorder() const NN_NOEXCEPT;
    void SetUsingThreadInfoRecorder(bool isEnabled) NN_NOEXCEPT;
    bool IsTaskProfileReaderEnabled() const NN_NOEXCEPT;
    void SetTaskProfileReaderEnabled(bool isEnabled) NN_NOEXCEPT;
    bool IsSoundThreadUpdateProfileReaderEnabled() const NN_NOEXCEPT;
    void SetSoundThreadUpdateProfileReaderEnabled(bool isEnabled) NN_NOEXCEPT;

private:
    void ShowProfile(nn::atk::SoundHandle& soundHandle) NN_NOEXCEPT;
    void ShowProfileUsingThreadInfoReader(nn::atk::SoundHandle& soundHandle) NN_NOEXCEPT;

    void ShowSoundProfile(nn::atk::SoundHandle& soundHandle, const nn::atk::SoundProfile& profile) NN_NOEXCEPT;
    void ShowTaskProfile(int profileCount) NN_NOEXCEPT;
    void ShowSoundThreadUpdateProfile(const nn::atk::SoundThreadUpdateProfile& profile) NN_NOEXCEPT;

#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    void DrawSoundProfile(nn::atk::SoundHandle& soundHandle, const nn::atk::SoundProfile& profile) NN_NOEXCEPT;
    void DrawTaskProfile(int profileCount) NN_NOEXCEPT;
    void DrawSoundThreadUpdateProfile(const nn::atk::SoundThreadUpdateProfile& profile) NN_NOEXCEPT;
#endif

    static const int SoundProfileCount = 32;

    int m_SoundThreadUpdateProfileCount;
    int m_TaskProfileCount;

    nn::atk::SoundProfile  m_SoundProfile[SoundProfileCount];
    nn::atk::ProfileReader m_ProfileReader;
    nn::os::Tick           m_PreviousAtkFrameProcessBegin;
    bool                   m_IsProfileReaderEnabled;
    bool                   m_IsFirstProfileRead;

    nn::atk::SoundThreadInfoRecorder m_SoundThreadInfoRecorder;
    bool                             m_IsUsingThreadInfoRecorder;

    nn::atk::SoundThreadUpdateProfile*      m_SoundThreadUpdateProfile;
    nn::atk::SoundThreadUpdateProfileReader m_SoundThreadUpdateProfileReader;
    nn::os::Tick                            m_PreviousSoundThreadUpdateProcessBegin;
    void* m_SoundThreadUpdateProfileReaderBuffer;
    bool                  m_IsSoundThreadUpdateProfileReaderEnabled;

    nn::atk::TaskProfile*      m_TaskProfile;
    nn::atk::TaskProfileReader m_TaskProfileReader;
    bool                       m_IsTaskProfileReaderEnabled;
    void* m_TaskProfileReaderBuffer;
};

