﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "AccountApplication_ProgramBase.h"

#include <nn/account/account_Types.h>

class Program final
    : public ProgramBase<Program>
{
    friend class ProgramBase<Program>;

private:
    enum Error
    {
        Error_Success,
        Error_Cancel,
        Error_Retry,
    };
    Error AcquireNsaIdToken(size_t* pOutSize, char* buffer, size_t bufferSize, const nn::account::UserHandle& handle) NN_NOEXCEPT;

    void SceneSingleUser(const nn::account::Uid& uid) NN_NOEXCEPT;
    void SceneSingleUserWithNetwork(const nn::account::UserHandle& handle) NN_NOEXCEPT;

protected:
    virtual void Execute() NN_NOEXCEPT final NN_OVERRIDE;

public:
    using ProgramBase<Program>::ThreadFunction;
};
