﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include "g3ddemo_ViewerUtility.h"

namespace g3ddemo = nn::g3d::demo;

void SetFallBackShadingModel(nn::g3d::ResShadingModel* pResShadingModel) NN_NOEXCEPT;

void InitializeRenderState(nn::gfx::Device* pDevice) NN_NOEXCEPT;
void FinalizeRenderState(nn::gfx::Device* pDevice) NN_NOEXCEPT;

enum UniformBlockType
{
    UniformBlockType_Env,
    UniformBlockType_View,
    UniformBlockType_TownContext,
    UniformBlockType_SelectedInfo,
    UniformBlockType_Count
};

void SetUniformBlock(UniformBlockType type, const nn::gfx::Buffer** pBufferArray, int arraySize) NN_NOEXCEPT;

class Viewer : public g3ddemo::DemoViewerBase
{
public:
    virtual void ModelFileLoaded(nn::g3d::viewer::ModelFileLoadedOutArg& outArg, const nn::g3d::viewer::ModelFileLoadedArg& inArg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ModelFileUnloaded(const nn::g3d::viewer::ModelFileUnloadedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TextureFileLoaded(const nn::g3d::viewer::TextureFileLoadedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TextureFileUnloaded(const nn::g3d::viewer::TextureFileUnloadedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ShaderAssignUpdated(const nn::g3d::viewer::ShaderAssignUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void MaterialUpdated(const nn::g3d::viewer::MaterialUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ShapeUpdated(const nn::g3d::viewer::ShapeUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void BoneBindUpdated(const nn::g3d::viewer::BoneBindUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SamplerParamUpdated(const nn::g3d::viewer::SamplerParamUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ModelLayoutUpdated(const nn::g3d::viewer::ModelLayoutUpdatedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SendModelLayoutRequested(nn::g3d::viewer::SendModelLayoutRequestedOutArg& outArg, const nn::g3d::viewer::SendModelLayoutRequestedArg& inArg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ModelDetached(const nn::g3d::viewer::ModelDetachedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ModelAttached(const nn::g3d::viewer::ModelAttachedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SceneAnimBound(const nn::g3d::viewer::SceneAnimBoundArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SceneAnimUnbound(const nn::g3d::viewer::SceneAnimUnboundArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void ApplySceneAnimRequested(const nn::g3d::viewer::ApplySceneAnimRequestedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TargetSelected(const nn::g3d::viewer::TargetSelectedArg& arg) NN_NOEXCEPT NN_OVERRIDE;
    void Initialize(g3ddemo::ResourceHolder& resourceHolder) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
};
