﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/win/demo_JoyPadDeviceWin.h>
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <windows.h>
#include <mmsystem.h>

namespace nw
{
namespace demo
{

JoyPadDeviceWin* JoyPadDeviceWin::s_pInstance = NULL;

//------------------------------------------------------------------------------
void
JoyPadDeviceWin::Initialize()
{
    m_PadNum = 0;

    // 性能情報と現在幾つ繋がっているかを取得する
    JOYCAPS jcs[ NUM_MAX ];
    int enable_pad_num = 0;

    for ( u32 i = 0; i < NUM_MAX; ++i )
    {
        if ( joyGetDevCaps(i, &jcs[i], sizeof(JOYCAPS)) == JOYERR_NOERROR && jcs[i].wNumButtons > 0 )
        {
            // DevCapsの取得に成功し、かつwNumButtonsが1以上の場合に有効なジョイパッドと見なす
            ++enable_pad_num;
        }
        else
        {
            // wNumButtonsを有効か否かのマークとして用いる
            jcs[i].wNumButtons = 0;
        }
    }

    // もしパッドがあれば、パッド情報のメモリを確保して性能情報を入れる
    if (enable_pad_num > 0)
    {
        for (u32 i = 0; i < NUM_MAX; i++)
        {
            if (jcs[i].wNumButtons > 0)
            {
                PadStatus& status = m_Pads[ m_PadNum ];

                NW_STATIC_ASSERT( sizeof(status.caps) >= sizeof(JOYCAPS) );
                NW_STATIC_ASSERT( sizeof(status.info) >= sizeof(JOYINFOEX) );

                *( reinterpret_cast<JOYCAPS*>(status.caps) ) = jcs[i];
                reinterpret_cast<JOYINFOEX*>(status.info)->dwSize = sizeof(JOYINFOEX);
                reinterpret_cast<JOYINFOEX*>(status.info)->dwFlags = JOY_RETURNALL;
                status.isEnable = false;
                status.id = i;
                ++m_PadNum;

                if ( m_PadNum >= enable_pad_num )
                {
                    break;
                }
            }
        }
    }
}

//------------------------------------------------------------------------------
void
JoyPadDeviceWin::Update()
{
    for( int i = 0; i < m_PadNum; ++i )
    {
        m_Pads[i].isEnable = ( joyGetPosEx(m_Pads[i].id, reinterpret_cast<JOYINFOEX*>( m_Pads[i].info )) == JOYERR_NOERROR );
    }
}

} // namespace demo
} // namespace nw

