﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/cafe/demo_WPadCafe.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
WPadCafe::WPadCafe(s32 channel)
: Pad(),
  m_Channel( channel ),
  m_IsConnected( false ),
  m_PadDevice( NULL )
{
}

//------------------------------------------------------------------------------
void
WPadCafe::GetKPadStatus( KPADStatus* pad )
{
    if ( m_PadDevice )
    {
        *pad = m_PadDevice->GetKPadInfo( m_Channel ).status[0];
    }
}

//------------------------------------------------------------------------------
void
WPadCafe::UpdateImpl()
{
    if ( m_PadDevice == NULL ) return;

    const WPadDeviceCafe::KPadInfo& kpadInfo = m_PadDevice->GetKPadInfo( m_Channel );

    if ( kpadInfo.lastReadLength > 0 || kpadInfo.lastReadError == KPAD_READ_ERR_NO_DATA )
    {
        const KPADStatus& lastStatus = kpadInfo.status[0];

        if ( lastStatus.dev_type != WPAD_DEV_NOT_FOUND )
        {
            u32 padHold = lastStatus.hold;

            m_PadHold.SetAllZero();
            m_PadHold.ChangeMask(MASK_A, padHold & KPAD_BUTTON_A);
            m_PadHold.ChangeMask(MASK_B, padHold & KPAD_BUTTON_B);
            m_PadHold.ChangeMask(MASK_1, padHold & KPAD_BUTTON_1);
            m_PadHold.ChangeMask(MASK_2, padHold & KPAD_BUTTON_2);
            m_PadHold.ChangeMask(MASK_Z, padHold & KPAD_BUTTON_Z);
            m_PadHold.ChangeMask(MASK_C, padHold & KPAD_BUTTON_C);
            m_PadHold.ChangeMask(MASK_PLUS | MASK_START, padHold & KPAD_BUTTON_PLUS);
            m_PadHold.ChangeMask(MASK_MINUS | MASK_SELECT, padHold & KPAD_BUTTON_MINUS);
            m_PadHold.ChangeMask(MASK_HOME, padHold & KPAD_BUTTON_HOME);
            m_PadHold.ChangeMask(MASK_RIGHT, padHold & KPAD_BUTTON_RIGHT);
            m_PadHold.ChangeMask(MASK_LEFT, padHold & KPAD_BUTTON_LEFT);
            m_PadHold.ChangeMask(MASK_UP, padHold & KPAD_BUTTON_UP);
            m_PadHold.ChangeMask(MASK_DOWN, padHold & KPAD_BUTTON_DOWN);

            // アナログスティックを設定
            if ( lastStatus.dev_type == WPAD_DEV_FREESTYLE || lastStatus.dev_type == WPAD_DEV_MPLS_FREESTYLE )
            {
                m_LeftStick.Set(lastStatus.ex_status.fs.stick.x, lastStatus.ex_status.fs.stick.y);
            }
            else
            {
                m_LeftStick.Set( 0.f, 0.f );
            }

            m_RightStick.Set( 0.f, 0.f );

            // トリガーはなし
            m_LeftAnalogTrigger = 0.f;
            m_RightAnalogTrigger = 0.f;

            // ポインタの値を設定
            m_PointerPrev = m_Pointer;
            SetPointerWithBound( lastStatus.dpd_valid_fg > 0, padHold & KPAD_BUTTON_A, nw::math::VEC2(lastStatus.pos.x, lastStatus.pos.y) );

            m_IsConnected = true;
        }
        else
        {
            m_IsConnected = false;
        }
    }
    else
    {
        m_IsConnected = false;
    }
}

} // namespace demo
} // namespace nw

