﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/cafe/demo_MouseCafe.h>
#include <nw/ut/ut_Inlines.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
MouseCafe::MouseCafe()
 : Mouse(),
   m_IsConnected( false ),
   m_Flag( MASK_ENABLE_CLAMP_POINTER ),
   m_KeyboardMouseDevice( NULL )
{
}

//------------------------------------------------------------------------------
void
MouseCafe::UpdateImpl()
{
    if ( m_MouseStatus == NULL && m_KeyboardMouseDevice == NULL )
    {
        return;
    }

    m_LeftStick = nw::math::VEC2::Zero();
    m_RightStick = nw::math::VEC2::Zero();

    m_LeftAnalogTrigger = 0.f;
    m_RightAnalogTrigger = 0.f;

    m_WheelDelta = 0;
    m_IsDoubleClick = false;

    if ( m_MouseStatus && m_MouseStatus->isEnable )
    {
        m_PadHold.SetDirect( m_MouseStatus->button );

        m_PointerPrev = m_Pointer;
        m_Pointer.Set( m_MouseStatus->posX, m_MouseStatus->posY );
        m_WheelDelta = m_MouseStatus->wheel;
        m_IsDoubleClick = m_MouseStatus->isDoubleClick;

        m_IsConnected = true;
    }
    else if ( m_KeyboardMouseDevice && m_KeyboardMouseDevice->IsAvailable() )
    {
        const nw::demo::KeyboardMouseDeviceCafe::MouseStatus& mouseEvent = m_KeyboardMouseDevice->GetMouseStatus();

        m_PointerPrev = m_Pointer;

        if ( m_KeyboardMouseDevice->GetMouseEventType() & KeyboardMouseDeviceCafe::DOWN )
        {
            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_LEFT )
            {
                m_PadHold.SetBitOn( IDX_LBUTTON );
            }

            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_RIGHT )
            {
                m_PadHold.SetBitOn( IDX_RBUTTON );
            }

            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_MIDDLE )
            {
                m_PadHold.SetBitOn( IDX_MBUTTON );
            }
        }

        if ( m_KeyboardMouseDevice->GetMouseEventType() & KeyboardMouseDeviceCafe::UP )
        {
            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_LEFT )
            {
                m_PadHold.SetBitOff( IDX_LBUTTON );
            }

            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_RIGHT )
            {
                m_PadHold.SetBitOff( IDX_RBUTTON );
            }

            if( mouseEvent.button == nw::mcs::MOUSEBUTTONTYPE_MIDDLE )
            {
                m_PadHold.SetBitOff( IDX_MBUTTON );
            }
        }

        if ( m_KeyboardMouseDevice->GetMouseEventType() & KeyboardMouseDeviceCafe::MOVE )
        {
            m_Pointer.x = static_cast<f32>( m_Pointer.x + mouseEvent.moveX );
            m_Pointer.y = static_cast<f32>( m_Pointer.y + mouseEvent.moveY );

            if ( IsEnableClampPointer() )
            {
                // m_PointerBoundMin、m_PointerBoundMax に有効な値が設定されているとき、
                // その範囲でポインタの値をクランプします。
                if ( !( m_PointerBoundMin.x >= m_PointerBoundMax.x || m_PointerBoundMin.y >= m_PointerBoundMax.y ) )
                {
                    m_Pointer.x = nw::ut::Clamp( m_Pointer.x, m_PointerBoundMin.x, m_PointerBoundMax.x );
                    m_Pointer.y = nw::ut::Clamp( m_Pointer.y, m_PointerBoundMin.y, m_PointerBoundMax.y );
                }

                m_PointerFlag.ChangeMask( POINTER_ON, true );
            }
            else
            {
                SetPointerWithBound( true, false, m_Pointer );
            }
        }

        if ( m_KeyboardMouseDevice->GetMouseEventType() & KeyboardMouseDeviceCafe::WHEEL )
        {
            m_WheelDelta = mouseEvent.wheel;
        }

        if ( m_KeyboardMouseDevice->GetMouseEventType() & KeyboardMouseDeviceCafe::DOUBLECLICK )
        {
            m_IsDoubleClick = true;
        }

        m_IsConnected = true;
    }
    else
    {
        m_Pointer.Set( 0.f, 0.f );
        m_PointerPrev.Set( 0.f, 0.f );
        m_IsConnected = false;
    }
}

} // namespace demo
} // namespace nw

