﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/gl/demo_FrameBufferUtilGL.h>
#include <nw/dev/dev_PrimitiveRenderer.h>
#include <nw/gfnd/gfnd_GraphicsContext.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
void
CopyToFrameBuffer( nw::gfnd::TextureGL* texture, GLuint frameBuffer, f32 width, f32 height, DisplayRotateState rotate )
{
    NW_ASSERT( width != 0.f && height != 0.f );

    // 転送先のサイズ（回転する場合は回転後）
    f32 displayWidth = width;
    f32 displayHeight = height;
    if ( rotate != DISPLAY_ROTATE_NONE )
    {
        displayWidth = height;
        displayHeight = width;
    }

    glBindFramebufferEXT( GL_FRAMEBUFFER_EXT, frameBuffer );
    {
        nw::gfnd::GraphicsContext context;
        context.SetDepthEnable( false, false );
        context.SetBlendEnable( false );
        context.SetColorMask( true, true, true, false );
        context.Apply();

        glViewport( 0, 0, static_cast<GLsizei>( displayWidth ), static_cast<GLsizei>( displayHeight ) );
        NW_GL_ASSERT();
        glScissor( 0, 0, static_cast<GLsizei>( displayWidth ), static_cast<GLsizei>( displayHeight ) );
        NW_GL_ASSERT();

        nw::math::MTX44 ProjMtx;
        nw::math::MTX34 ViewMtx;

        nw::dev::PrimitiveRenderer* renderer = nw::dev::PrimitiveRenderer::GetInstance();
        nw::math::MTX34 modelMtx = renderer->GetModelMatrix();
        renderer->SetModelMatrix( nw::math::MTX34::Identity() );

        nw::math::MTX44Ortho(
            &ProjMtx,
            -displayWidth / 2.0f,
             displayWidth / 2.0f,
            -displayHeight / 2.0f,
             displayHeight / 2.0f,
            0.f,
            1.f
        );
        renderer->SetProjectionMtx( &ProjMtx );

        nw::math::MTX34Identity( &ViewMtx );
        switch ( rotate )
        {
        case DISPLAY_ROTATE_NONE:
            break;
        case DISPLAY_ROTATE_CLOCKWISE:
            ViewMtx._00 = 0;
            ViewMtx._01 = 1;
            ViewMtx._10 = -1;
            ViewMtx._11 = 0;
            break;
        case DISPLAY_ROTATE_COUNTERCLOCKWISE:
            ViewMtx._00 = 0;
            ViewMtx._01 = -1;
            ViewMtx._10 = 1;
            ViewMtx._11 = 0;
            break;
        default:
            break;
        }
        renderer->SetViewMtx( &ViewMtx );

        renderer->Begin();
        {
            nw::dev::PrimitiveRenderer::QuadArg arg;
            arg.SetCornerAndSize( nw::math::VEC3( -width / 2.f, -height / 2.f, 0.f ), nw::math::VEC2( width, height ) );
            renderer->DrawQuad( *texture, arg );
        }
        renderer->End();

        renderer->SetModelMatrix( modelMtx );
    }
}

} // namespace demo
} // namespace nw
