﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_W_PAD_CAFE_H_
#define NW_DEMO_W_PAD_CAFE_H_

#include <nw/demo/pad/demo_Pad.h>
#include <nw/demo/pad/cafe/demo_WPadDeviceCafe.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe の WPAD を扱うクラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class WPadCafe : public Pad
{
public:
    NW_UT_RUNTIME_TYPEINFO(Pad)

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //!
    //! @param[in]    channel   接続先のチャンネルです。
    //---------------------------------------------------------------------------
    explicit WPadCafe(s32 channel);

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~WPadCafe() {}

    //---------------------------------------------------------------------------
    //! @brief        接続されているチャンネルを取得します。
    //!
    //! @return       チャンネルを返します。
    //---------------------------------------------------------------------------
    int GetChannel() const { return m_Channel; }

    //---------------------------------------------------------------------------
    //! @brief        パッドが接続状態にあるか否かを返します。
    //!
    //! @return       接続されている場合、 true を返します。
    //---------------------------------------------------------------------------
    virtual bool IsConnected() const { return m_IsConnected; }

    //---------------------------------------------------------------------------
    //! @brief        パッドデバイスを設定します。
    //!
    //! @param[in]    device    設定するデバイスへのポインタです。
    //---------------------------------------------------------------------------
    void SetWPadDevice( WPadDeviceCafe* device ){ m_PadDevice = device; }

    //---------------------------------------------------------------------------
    //! @brief        KPAD パッド状態を取得します。
    //!
    //! @param[out]   pad        出力するパッド状態へのポインタです。
    //---------------------------------------------------------------------------
    void GetKPadStatus( KPADStatus* pad );


protected:
    virtual void UpdateImpl();

    s32  m_Channel;      //!< 接続されているチャンネルです。
    bool m_IsConnected; //!< 接続されているかを表します。

    WPadDeviceCafe* m_PadDevice; //!< 使用するパッドデバイスです。
};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_W_PAD_CAFE_H_
