﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_FRAME_BUFFER_UTIL_GL_H_
#define NW_DEMO_FRAME_BUFFER_UTIL_GL_H_

#include <nw/gfnd/gl/gfnd_TextureGL.h>

namespace nw
{
namespace demo
{

//! @brief バッファの回転状態です。（WindowsでのDRCの回転用です）
enum DisplayRotateState
{
    DISPLAY_ROTATE_NONE = 0,        //!< DRCを回転しません。
    DISPLAY_ROTATE_CLOCKWISE,       //!< DRCを時計回りに回転します。
    DISPLAY_ROTATE_COUNTERCLOCKWISE //!< DRCを反時計回りに回転します。
};

//---------------------------------------------------------------------------
//! @brief        フレームバッファにテクスチャ画像をコピーします。
//!
//! @param[in]    texture       コピーするテクスチャです。
//! @param[in]    frameBuffer   コピー先のフレームバッファです。
//! @param[in]    width         フレームバッファの幅です。（回転前）
//! @param[in]    height        フレームバッファの高さです。（回転前）
//! @param[in]    rotate        コピーするときの回転です。
//---------------------------------------------------------------------------
void CopyToFrameBuffer( nw::gfnd::TextureGL* texture, GLuint frameBuffer, f32 width, f32 height, DisplayRotateState rotate = DISPLAY_ROTATE_NONE );

} // namespace demo
} // namespace nw

#endif // NW_DEMO_FRAME_BUFFER_UTIL_GL_H_
