﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_H_
#define NW_DEMO_H_

/*!
  @namespace  nw::demo
  @brief      デモライブラリの名前空間です。
  @details    NW4F のデモ作成用のライブラリのため、予告なく変更が行われる場合があります。予めご了承ください。

              デモライブラリの関数の一部は、内部で Cafe SDK の Host IO ライブラリの関数を使用します。
              マスター ROM では nw::demo 名前空間の関数は使用しないようにしてください。
*/

#include <nw/demo/demo_Main.h>
#include <nw/demo/demo_System.h>
#include <nw/demo/demo_FrameBuffer.h>
#include <nw/demo/demo_TestUtility.h>
#include <nw/demo/demo_DefaultAllocator.h>
#include <nw/demo/pad/demo_Pad.h>
#include <nw/demo/pad/demo_PadProcessor.h>
#include <nw/demo/pad/demo_Mouse.h>

/* NW_DEMO_H_ */
#endif
