﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{AlignedAllocator.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a simple aligned allocator
 *  that takes care of keeping track of the original
 *  allocation while returning the aligned pointer.
 */

#pragma once

#include <nn/nn_Assert.h>
#include <nn/mem/mem_StandardAllocator.h>

class AlignedAllocator
{
    NN_DISALLOW_COPY(AlignedAllocator);

    public:
        ~AlignedAllocator();

        void* Allocate(size_t size, size_t alignment);
        void Deallocate(void* pData);

        static AlignedAllocator* GetInstance()
        {
            static AlignedAllocator instance;

            return &instance;
        }

    private:
        AlignedAllocator();

        void* m_Memory;
        nn::mem::StandardAllocator m_Allocator;
};
