﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       DebugPad のデバイスアセットに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_DebugPad.h>
#include <nns/hid/hid_DeviceAsset.h>
#include <nns/hid/hid_DeviceAssetId.h>

namespace nns { namespace hid {

/**
 * @brief   DebugPad のデバイスアセットクラスです。
 */
class DebugPadAsset : public DeviceAsset
{
    NN_DISALLOW_COPY(DebugPadAsset);
    NN_DISALLOW_MOVE(DebugPadAsset);

public:
    /**
     * @brief       DebugPadAsset のコンストラクタです。
     *
     * @pre
     *              - 事前に 1 回以上 Initialize() が呼び出されている
     *
     * @param[in]   pManager                    DebugPad のデバイスアセットの管理者です。
     */
    explicit DebugPadAsset(ControllerManager* pManager) NN_NOEXCEPT;

    /**
     * @brief       DebugPadAsset のデストラクタです。
     */
    virtual ~DebugPadAsset() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       DebugPad を初期化します。
     */
    static void Initialize() NN_NOEXCEPT;

    /**
     * @brief       DebugPad のデバイスアセット識別子を返します。
     *
     * @return      DebugPad のデバイスアセット識別子です。
     */
    virtual DeviceAssetId GetDeviceAssetId() NN_NOEXCEPT NN_OVERRIDE
    {
        return DeviceAssetId_DebugPad;
    }

    /**
     * @brief       DebugPad のデバイスアセットを更新します。
     *
     * @details     更新はフレーム毎に行う必要があります。
     */
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       DebugPad の入力状態を返します。
     *
     * @return      DebugPad の入力状態です。
     */
    const nn::hid::DebugPadState& GetDebugPadState() const NN_NOEXCEPT
    {
        return m_State;
    }

private:
    nn::hid::DebugPadState m_State; //!< 入力状態読み出し用のバッファです。
};

}} // namespace nns::hid
