﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       DebugPad の機能を持つコントローラに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nns/hid/hid_Controller.h>
#include <nns/hid/hid_ControllerId.h>
#include <nns/hid/hid_ControllerManager.h>
#include <nns/hid/hid_DebugPadAsset.h>

namespace nns { namespace hid {

/**
 * @brief   DebugPad の機能を持つコントローラクラスです。
 */
class DebugPad : public Controller
{
    NN_DISALLOW_COPY(DebugPad);
    NN_DISALLOW_MOVE(DebugPad);

public:
    /**
     * @brief       DebugPad のコンストラクタです。
     *
     * @param[in]   pManager                    DebugPad の管理者です。
     *
     * @pre
     *              - pManager != NULL
     */
    explicit DebugPad(ControllerManager* pManager) NN_NOEXCEPT;

    /**
     * @brief       DebugPad のデストラクタです。
     */
    virtual ~DebugPad() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       DebugPad の状態を更新します。
     *
     * @details     更新はフレーム毎に行う必要があります。
     */
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       DebugPad のコントローラ識別子を返します。
     *
     * @return      DebugPad のコントローラ識別子です。
     */
    virtual ControllerId GetControllerId() NN_NOEXCEPT NN_OVERRIDE
    {
        return ControllerId_DebugPad;
    }

    /**
     * @brief       DebugPad が接続状態にあるか否かを返します。
     *
     * @return      DebugPad が接続状態にあるか否かを表す値です。
     */
    virtual bool IsConnected() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_IsConnected;
    }

private:
    DebugPadAsset* m_pDebugPadAsset;  //!< 対応する DebugPad のデバイスアセットです。

    bool m_IsConnected;               //!< DebugPad が接続状態にあるか否かを表す値です。
};

}} // namespace nns::hid
