﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       コントローラの状態を表す属性値に関する API の宣言
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nns { namespace hid {

/**
 * @brief      コントローラの状態を表す属性値です。
 */
struct Attribute
{
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 0> IsConnected;          //!< Npad の物理的な接続状態
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 1> IsWired;              //!< Npad がケーブルで何か対応デバイスに接続されているかどうか
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 2> IsLeftConnected;      //!< Joy-Con (L) の物理的な接続状態
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 3> IsLeftWired;          //!< Joy-Con (L) がケーブルで何か対応デバイスに接続されているかどうか
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 4> IsRightConnected;     //!< Joy-Con (R) の物理的な接続状態
    typedef nn::util::BitFlagSet<32, Attribute>::Flag< 5> IsRightWired;         //!< Joy-Con (R) がケーブルで何か対応デバイスに接続されているかどうか
};

/**
 * @brief       コントローラの状態を表す属性値の集合を扱う型です。
 */
typedef nn::util::BitFlagSet<32, Attribute> AttributesSet;


}} // namespace nns::hid
