﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nns/display0/display0_IDisplay0Driver.sfdl.h>

namespace nns { namespace display0 {

//-----------------------------------------------------------------------------
//  実装オブジェクトに直接アクセスする場合に、
//  オブジェクトへの参照を取得する関数
//-----------------------------------------------------------------------------
nn::sf::SharedPointer<IDisplay0Driver> CreateDisplay0DriverByDfc() NN_NOEXCEPT;


//-----------------------------------------------------------------------------
//  実装オブジェクトに HIPC を介してアクセスする場合に、
//  オブジェクトへの参照を取得する関数
//-----------------------------------------------------------------------------
nn::sf::SharedPointer<IDisplay0Driver> CreateDisplay0DriverByHipc() NN_NOEXCEPT;


//-----------------------------------------------------------------------------

}}  // namespace nns::display0

