﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "dbgui_InterfaceInfo.h"


namespace nns { namespace dbgui {

/**
* @name シザリングステート情報を変換するコールバック
* @{
*/

/**
* @brief ScalableViewportのインスタンスを使って、シザリングステート情報を変換するコールバックです。
*
* @see UpdateScissorCallback
* @see InterfaceInfo::SetUpdateScissorCallback
*
* @param[inout]     pScissorStateInfo           シザリングステート情報
* @param[in]        pScalableViewportAsVoid     ScalableViewportのインスタンスへのポインタ
*/
void UpdateScissorScalableViewport(
    nn::gfx::ScissorStateInfo* pScissorStateInfo,
    void* pScalableViewportAsVoid);

/**
* @brief Y軸を逆転して、シザリングステート情報を変換するコールバックです。
*
* @see UpdateScissorCallback
* @see InterfaceInfo::SetUpdateScissorCallback
*
* @param[inout]     pScissorStateInfo           シザリングステート情報
* @param[in]        pViewportHeightAsVoid       ビューポートの縦幅（ int 型）へのポインタ
*/
void UpdateScissorInvertYAxis(
    nn::gfx::ScissorStateInfo* pScissorStateInfo,
    void* pViewportHeightAsVoid);

/**
* @}
*/

} } // namespace nns { namespace dbgui {
