﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>

#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_NpadHandheld.h>
#include <nn/util/util_BitFlagSet.h>

#include <nns/console/console_InputEventListener.h>

namespace nns {
namespace console {
namespace detail {

class DebugPadContext
{
private:
    std::pair<int, int> m_RepeatInterval;
    std::pair<bool, int> m_ButtonRepeatedCounts[32];

    bool m_HasPrevious;
    nn::hid::DebugPadState m_PreviousState;

    PadEventListenerBase* m_pEventListener;

public:
    DebugPadContext(int intervalFirst, int interval) NN_NOEXCEPT;
    void SetEventListener(PadEventListenerBase* pEventListener) NN_NOEXCEPT;
    void UnsetEventListener() NN_NOEXCEPT;
    bool TryUpdate() NN_NOEXCEPT;
    std::pair<nn::hid::AnalogStickState, nn::hid::AnalogStickState> GetAnalogStickState() const NN_NOEXCEPT;
};

class NpadContext
{
public:
    struct NpadState
    {
        int64_t samplingNumber;
        nn::hid::NpadButtonSet buttons;
        nn::hid::AnalogStickState analogStickL;
        nn::hid::AnalogStickState analogStickR;
        nn::hid::NpadAttributesSet attributes;
    };

private:
    const nn::hid::NpadIdType m_Id;
    std::pair<int, int> m_RepeatInterval;
    std::pair<bool, int> m_ButtonRepeatedCounts[64];

    bool m_HasPrevious;
    NpadState m_PreviousState;

    PadEventListenerBase* m_pEventListener;

    NpadState GetNpadState() const NN_NOEXCEPT;

public:
    NpadContext(const nn::hid::NpadIdType& id, int intervalFirst, int interval) NN_NOEXCEPT;
    void SetEventListener(PadEventListenerBase* pEventListener) NN_NOEXCEPT;
    void UnsetEventListener() NN_NOEXCEPT;
    bool TryUpdate() NN_NOEXCEPT;
    std::pair<nn::hid::AnalogStickState, nn::hid::AnalogStickState> GetAnalogStickState() const NN_NOEXCEPT;
};

class PadContext
{
private:
    enum class SelectedPad
    {
        None,
        DebugPad,
        NpadNo1,
        NpadHandheld,
    } m_LastSelectedPad;

    DebugPadContext m_DebugPadContext;
    NpadContext m_NpadContextNo1;
    NpadContext m_NpadContextHandheld;

public:
    PadContext(int intervalFirst, int interval) NN_NOEXCEPT;
    void SetEventListener(PadEventListenerBase* pEventListener) NN_NOEXCEPT;
    void UnsetEventListener() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
    std::pair<nn::hid::AnalogStickState, nn::hid::AnalogStickState> GetAnalogStickState() const NN_NOEXCEPT;
};

class KeyboardContext
{
private:
    std::pair<int, int> m_RepeatInterval;
    std::pair<bool, int> m_KeyRepeatedCounts[256];
    std::pair<bool, int> m_ModifierRepeatedCounts[32];

    bool m_HasPrevious;
    nn::hid::KeyboardState m_PreviousState;

    KeyboardEventListenerBase* m_pEventListener;

public:
    KeyboardContext(int intervalFirst, int interval) NN_NOEXCEPT;
    void SetEventListener(KeyboardEventListenerBase* pEventListener) NN_NOEXCEPT;
    void UnsetEventListener() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
};

} // ~namespace nns::console::detail
}
}
