﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/hid_Npad.h>

namespace nns { namespace audio {

NN_FORCEINLINE
void ConvertDebugPadButtonsToNpadButtons(nn::hid::NpadButtonSet* out, const nn::hid::DebugPadButtonSet& in) NN_NOEXCEPT
{
    if (in.Test<nn::hid::DebugPadButton::A>())
    {
        out->Set(nn::hid::NpadButton::A::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::B>())
    {
        out->Set(nn::hid::NpadButton::B::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::X>())
    {
        out->Set(nn::hid::NpadButton::X::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Y>())
    {
        out->Set(nn::hid::NpadButton::Y::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Up>())
    {
        out->Set(nn::hid::NpadButton::Up::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Down>())
    {
        out->Set(nn::hid::NpadButton::Down::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Left>())
    {
        out->Set(nn::hid::NpadButton::Left::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Right>())
    {
        out->Set(nn::hid::NpadButton::Right::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::L>())
    {
        out->Set(nn::hid::NpadButton::L::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::R>())
    {
        out->Set(nn::hid::NpadButton::R::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::ZL>())
    {
        out->Set(nn::hid::NpadButton::ZL::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::ZR>())
    {
        out->Set(nn::hid::NpadButton::ZR::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Start>())
    {
        out->Set(nn::hid::NpadButton::Plus::Index);
    }
    if (in.Test<nn::hid::DebugPadButton::Select>())
    {
        out->Set(nn::hid::NpadButton::Minus::Index);
    }
}

}}  //  namespace nns::audio
