﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nns { namespace afx {

/**
 * @brief       SimpleDelay の初期化パラメータです。
 */
struct SimpleDelayConstant
{
    //! @brief      サンプルレートです。
    //!             1 以上の値を指定する必要があります。
    int sampleRate;

    //! @brief      チャンネル数です。
    //!             1 以上の値を指定する必要があります。
    int channelCount;

    //! @brief      遅延時間の最大値（ミリ秒）です。
    //!             1 以上の値を指定する必要があります。
    int delayTimeMax;
};

/**
 * @brief       SimpleDelay の可変パラメータです。
 */
struct SimpleDelayParameter
{
    //! @brief      遅延時間（ミリ秒）です。
    //!             1 以上 SimpleDelayConstant::delayTimeMax 以下の値を指定する必要があります。
    int delayTime;

    //! @brief      フィードバックゲインです。
    //!             0.0f 以上 1.0f 以下の値を指定する必要があります。
    float feedbackGain;

    //! @brief      フィードバックに対するローパスフィルタの効果の大きさです。
    //!             0.0f 以上 1.0f 以下の値を指定する必要があります。
    float damping;
};

/**
 * @brief       SimpleDelay の管理構造体です。
 */
struct SimpleDelayType
{
    void* _buffer;
    size_t _size;
};

}}  // namespace nns::afx
