﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nns { namespace afx {

/**
 * @brief       SimpleChorus の初期化パラメータです。
 */
struct SimpleChorusConstant
{
    //! @brief      サンプルレートです。
    //!             1 以上の値を指定する必要があります。
    int sampleRate;

    //! @brief      チャンネル数です。
    //!             1 以上の値を指定する必要があります。
    int channelCount;
};

/**
 * @brief       SimpleChorus の可変パラメータです。
 */
struct SimpleChorusParameter
{
    //! @brief      遅延の中心値（ミリ秒）です。
    //!             1 以上 50 以下の値を指定する必要があります。
    int baseDelay;

    //! @brief      遅延の振幅（ミリ秒）です。
    //!             0 以上 baseDelay 以下の値を指定する必要があります。
    //!             遅延は [baseDelay - vibration, baseDelay + vibration] の範囲で振動します。
    int vibration;

    //! @brief      遅延の振動周期（ミリ秒）です。
    //!             500 以上 10000 以下の値を指定する必要があります。
    int period;
};

/**
 * @brief       SimpleChorus の管理構造体です。
 */
struct SimpleChorusType
{
    void* _buffer;
    size_t _size;
};

}}  // namespace nns::afx
