﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//------------------------------------------------------------------
// デモ: SharedPtr
//
// 概要
//   nw::ut::SharedPtr クラスのデモです。
//   テンプレート引数に LockObject を指定するスレッドセーフ版と、
//   デフォルトの非スレッドセーフ版の SharedPtr を作成します。
//------------------------------------------------------------------

#define NW_CONSOLE_ENABLE

#include <nw/demo/demo_Main.h>
#include <nw/demo/demo_DefaultAllocator.h>
#include <nw/ut.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe.h>
#endif

// クラスBase
class Base
{
public:
    virtual ~Base() {}
};

// クラスAAA
class AAA : public Base
{
public:
    virtual ~AAA()
    {
        NW_LOG("destruct AAA\n");
    }
};

// クラスBBB
class BBB : public Base
{
public:
    virtual ~BBB()
    {
        NW_LOG("destruct BBB\n");
    }
};

#define HEAP_SIZE ( 32 * 1024 )

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  サンプルのメイン関数です。

  Arguments:    なし。

  Returns:      なし。
 *---------------------------------------------------------------------------*/
int
NwDemoMain(int /* argc */, char ** /* argv */)
{
    nw::demo::DefaultAllocator defaultAllocator;
    nw::ut::MemoryAllocator allocator;
    allocator.Initialize(defaultAllocator.Alloc(HEAP_SIZE),HEAP_SIZE);

    nw::ut::WeakPtr<AAA> pWeakAAA;
    nw::ut::WeakPtr<Base, nw::ut::Mutex> pWeakBase;
    nw::ut::SharedPtr<Base> pBaseA;

    {
        AAA*     objA = new(allocator.Alloc(sizeof(AAA))) AAA();
        BBB*     objB = new(allocator.Alloc(sizeof(BBB))) BBB();

        nw::ut::SharedPtr<AAA>  pAAA = nw::ut::SharedPtr<AAA>( objA, &allocator );
        nw::ut::SharedPtr<BBB, nw::ut::Mutex> pBBB = nw::ut::SharedPtr<BBB, nw::ut::Mutex>( objB, &allocator );

        // pWeakBase = pAAA; // Error! 排他方式の違うものへの代入はコンパイルエラー。

        pBaseA = pAAA;
        pWeakAAA = pAAA;
        pWeakBase = pBBB;

        if (pAAA == pBaseA)
        {
            NW_LOG("pAAA == pBaseA\n");
        }

        if (pBaseA == pWeakAAA.Lock())
        {
            NW_LOG("pBaseA == pWeakAAA\n");
        }

        if (pBBB == pWeakBase.Lock())
        {
            NW_LOG("pBBB == pWeakBBB\n");
        }
    }

    if ( pWeakAAA.Lock() )
    {
        NW_LOG("AAA is not released\n");
    }
    else
    {
        NW_LOG("AAA is already released\n");
    }

    if ( pWeakBase.Lock() )
    {
        NW_LOG("BBB is not released\n");
    }
    else
    {
        NW_LOG("BBB is already released\n");
    }

    NW_LOG( "End of demo.\n" );
    return 0;
}



