﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef SOUND_DEMO_UTILITY_H_
#define SOUND_DEMO_UTILITY_H_

#include <nw/demo.h>
#include <nw/dev.h>
#include <nw/gfnd.h>
#include <nw/math.h>
#include <nw/ut.h>

class SimpleModel;

// DRCを利用するかどうか
//#define USE_DRC

#if defined(USE_DRC)
//---------------------------------------------------------------------------
//! @brief        デモシステムです。
//---------------------------------------------------------------------------
class SimpleDemoSystemDRC : public nw::demo::DemoSystemDRC
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    /* ctor */ SimpleDemoSystemDRC( const CreateArg& arg )
        : nw::demo::DemoSystemDRC( arg )
    {}

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
    //---------------------------------------------------------------------------
    //! @brief        カラーバッファを取得します。
    //---------------------------------------------------------------------------
    GLuint GetColorTexture()
    {
        return m_Color.GetID();
    }

    //---------------------------------------------------------------------------
    //! @brief        デプスバッファを取得します。
    //---------------------------------------------------------------------------
    GLuint GetDepthTexture()
    {
        return m_Depth.GetID();
    }
#endif

#ifdef NW_PLATFORM_CAFE
    //---------------------------------------------------------------------------
    //! @brief        カラーバッファを取得します。
    //---------------------------------------------------------------------------
    GX2ColorBuffer* GetColorTexture()
    {
        return &m_ColorBuffer;
    }

    //---------------------------------------------------------------------------
    //! @brief        デプスバッファを取得します。
    //---------------------------------------------------------------------------
    GX2DepthBuffer* GetDepthTexture()
    {
        return &m_DepthBuffer;
    }
#endif
};
#else
//---------------------------------------------------------------------------
//! @brief        デモシステムです。
//---------------------------------------------------------------------------
class SimpleDemoSystem : public nw::demo::DemoSystem
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    /* ctor */ SimpleDemoSystem( const CreateArg& arg )
        : nw::demo::DemoSystem( arg )
    {}

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
    //---------------------------------------------------------------------------
    //! @brief        カラーバッファを取得します。
    //---------------------------------------------------------------------------
    GLuint GetColorTexture()
    {
        return m_Color.GetID();
    }

    //---------------------------------------------------------------------------
    //! @brief        デプスバッファを取得します。
    //---------------------------------------------------------------------------
    GLuint GetDepthTexture()
    {
        return m_Depth.GetID();
    }
#endif

#ifdef NW_PLATFORM_CAFE
    //---------------------------------------------------------------------------
    //! @brief        カラーバッファを取得します。
    //---------------------------------------------------------------------------
    GX2ColorBuffer* GetColorTexture()
    {
        return &m_ColorBuffer;
    }

    //---------------------------------------------------------------------------
    //! @brief        デプスバッファを取得します。
    //---------------------------------------------------------------------------
    GX2DepthBuffer* GetDepthTexture()
    {
        return &m_DepthBuffer;
    }
#endif
};
#endif

class SoundDemoSystem
{
public:
    SoundDemoSystem();
    ~SoundDemoSystem();

public:
    void Initialize(nw::ut::IAllocator& allocator);
    void Finalize();
    void ProcCamera();
    void ProcFrame();
    void ProcBackGroundDraw();

    void UpdateViewBlock(SimpleModel& model);

    const nw::math::MTX34& GetCameraMatrix() const { return m_ViewMatrix; }

#if defined(USE_DRC)
    SimpleDemoSystemDRC& GetDemoSystem()
#else
    SimpleDemoSystem& GetDemoSystem()
#endif
    {
        NW_ASSERT_NOT_NULL(m_Demo);
        return *m_Demo;
    }

private:

    // アロケータ
    nw::ut::IAllocator*     m_Allocator;

    // デモシステム
#if defined(USE_DRC)
    SimpleDemoSystemDRC*    m_Demo;
#else
    SimpleDemoSystem*       m_Demo;
#endif

    f32 m_CameraPosX;
    f32 m_CameraPosZ;

    // ビュー設定
    nw::math::MTX44         m_ProjctionMatrix;
    nw::math::MTX34         m_ViewMatrix;
    nw::math::VEC3          m_CameraPosition;
    nw::math::VEC3          m_CameraLookAt;
#if defined(USE_DRC)
    nw::math::MTX44         m_ProjctionMatrixDRC;
    nw::math::MTX34         m_ViewMatrixDRC;
    nw::math::VEC3          m_CameraPositionDRC;
    nw::math::VEC3          m_CameraLookAtDRC;
#endif
};

#endif // ifndef SOUND_DEMO_UTILITY_H_
