﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/types.h>
#include <nw/ut.h>

// ----------------------------------------------------------------------------
// アロケータ
// ----------------------------------------------------------------------------
class SimpleAllocator : public nw::ut::MemoryAllocator
{
public:
    SimpleAllocator()
    {
    }

    virtual void* Alloc(size_t size, u32 alignment)
    {
        return nw::ut::MemoryAllocator::Alloc(size, static_cast<u32>(alignment));
    }

    virtual void Free(void* ptr)
    {
        nw::ut::MemoryAllocator::Free(ptr);
    }
};

class LoggingAllocator : public SimpleAllocator
{
public:
    LoggingAllocator()
        : m_OccupiedSize(0)
        , m_MaxSize(0)
        , m_pTop(NULL)
        , m_pBottom(NULL)
    {
    }

    virtual void* Alloc(size_t size, u32 alignment)
    {
        return AllocateMemory(size, static_cast<size_t>(alignment));
    }

    virtual void Free(void* ptr)
    {
        FreeMemory(ptr);
    }

    void* AllocateMemory(size_t size, size_t alignment);

    void FreeMemory(void* pointer);

    // 確保中の総メモリサイズを取得します
    int64_t GetOccupiedSize() const;

    // メモリの最大使用量を取得します
    int64_t GetMaxSize() const;

    // 確保中のメモリを列挙して表示します
    void PrintOccupiedMemory() const;

private:
    // メモリのアドレスとサイズをリストで管理
    struct MemoryList
    {
        MemoryList* pNext;
        void* pAddress;
        size_t size;
    };

    int64_t m_OccupiedSize;
    int64_t m_MaxSize;
    MemoryList* m_pTop;
    MemoryList* m_pBottom;
};
