﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 300 es

layout(location = 0) in vec4 i_Position;
layout(location = 1) in vec3 i_Normal;
layout(location = 2) in vec2 i_UV;
layout(location = 3) in ivec4 i_Index;
layout(location = 4) in vec4 i_Weight;

out vec3 normal;
out vec4 color;
out vec2 uv;

layout(std140) uniform Skeleton
{
    vec4 mtxPalette[3 * 128]; // RADEON では配列のサイズを超えてアクセスできない。
};

layout(std140) uniform Shape
{
    vec4 shapeMtx[3];
    int vtxSkinCount;
};

layout(std140) uniform View
{
    vec4 projMtx[4];
    vec4 cameraMtx[3];
};

void main()
{
    vec4 pos_w = vec4(0, 0, 0, 1);
    vec3 nrm_w = vec3(0, 0, 0);

    // 分岐によるパフォーマンス度外視の実装。
    if (vtxSkinCount == 0)
    {
        pos_w.x = dot(shapeMtx[0], i_Position);
        pos_w.y = dot(shapeMtx[1], i_Position);
        pos_w.z = dot(shapeMtx[2], i_Position);
        nrm_w.x = dot(shapeMtx[0].xyz, i_Normal);
        nrm_w.y = dot(shapeMtx[1].xyz, i_Normal);
        nrm_w.z = dot(shapeMtx[2].xyz, i_Normal);
    }
    else if (vtxSkinCount == 1)
    {
        int mtxIndex = i_Index.x * 3;
        pos_w.x = dot(mtxPalette[mtxIndex + 0], i_Position);
        pos_w.y = dot(mtxPalette[mtxIndex + 1], i_Position);
        pos_w.z = dot(mtxPalette[mtxIndex + 2], i_Position);
        nrm_w.x = dot(mtxPalette[mtxIndex + 0].xyz, i_Normal);
        nrm_w.y = dot(mtxPalette[mtxIndex + 1].xyz, i_Normal);
        nrm_w.z = dot(mtxPalette[mtxIndex + 2].xyz, i_Normal);
    }
    else
    {
        for (int i = 0; i < vtxSkinCount; ++i)
        {
            int mtxIndex;
            if (i == 0)
            {
                mtxIndex = i_Index.x * 3;
            }
            else if (i == 1)
            {
                mtxIndex = i_Index.y * 3;
            }
            else if (i == 2)
            {
                mtxIndex = i_Index.z * 3;
            }
            else
            {
                mtxIndex = i_Index.w * 3;
            }

            float weight;
            if (i == 0)
            {
                weight = i_Weight.x;
            }
            else if (i == 1)
            {
                weight = i_Weight.y;
            }
            else if (i == 2)
            {
                weight = i_Weight.z;
            }
            else
            {
                weight = i_Weight.w;
            }
            pos_w.x += weight * dot(mtxPalette[mtxIndex + 0], i_Position);
            pos_w.y += weight * dot(mtxPalette[mtxIndex + 1], i_Position);
            pos_w.z += weight * dot(mtxPalette[mtxIndex + 2], i_Position);
            nrm_w.x += weight * dot(mtxPalette[mtxIndex + 0].xyz, i_Normal);
            nrm_w.y += weight * dot(mtxPalette[mtxIndex + 1].xyz, i_Normal);
            nrm_w.z += weight * dot(mtxPalette[mtxIndex + 2].xyz, i_Normal);
        }
    }

    vec4 pos_v;
    pos_v.x = dot(cameraMtx[0], pos_w);
    pos_v.y = dot(cameraMtx[1], pos_w);
    pos_v.z = dot(cameraMtx[2], pos_w);
    pos_v.w = 1.0;

    gl_Position.x = dot(projMtx[0], pos_v);
    gl_Position.y = dot(projMtx[1], pos_v);
    gl_Position.z = dot(projMtx[2], pos_v);
    gl_Position.w = dot(projMtx[3], pos_v);

    normal.x = dot(cameraMtx[0].xyz, nrm_w);
    normal.y = dot(cameraMtx[1].xyz, nrm_w);
    normal.z = dot(cameraMtx[2].xyz, nrm_w);

    uv = i_UV;

    vec3 up = vec3(0, 1, 0);
    float rate = dot(nrm_w, up) * 0.5 + 0.5;
    color.rgb = rate * vec3(0.7, 0.7, 0.9) + (1.0 - rate) * vec3(0.3, 0.2, 0.2);
    color.a = pow(clamp(1.0 - abs(normal.z), 0.0, 1.0), 2.0) * 0.2;
}
