﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 300 es

precision highp float;

in vec3 normal;
in vec4 color;
in vec2 uv;

layout(location = 0) out vec4 o_Color;

uniform sampler2D albedoTex;

layout(std140) uniform Material
{
    vec3 offset;
};

void main()
{
    vec4 albedo = texture(albedoTex, uv);
    float rim = color.a;
    o_Color.rgb = albedo.rgb * color.rgb;
    o_Color.rgb += vec3(rim, rim, rim);
    o_Color.rgb += offset;
    o_Color.a = albedo.a;
}
