/*---------------------------------------------------------------------------*
 Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.
 
 These coded instructions, statements, and computer programs contain
 proprietary information of Nintendo of America Inc. and/or Nintendo
 Company Ltd., and are protected by Federal copyright law.  They may
 not be disclosed to third parties or copied or duplicated in any form,
 in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#import "GameViewController.h"
#import "Simple.h"

@interface GameViewController () {
}
@property (strong, nonatomic) EAGLContext *context;

- (void)setupGL;
- (void)tearDownGL;

@end

@implementation GameViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // コンテキストはアプリ、g3d両方で使用します。
    self.context = [[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES3];

    if (!self.context) {
        NSLog(@"Failed to create ES context");
    }
    
    // 望むフレームレートを指定
    self.preferredFramesPerSecond = 60;
    GLKView *view = (GLKView *)self.view;
    view.context = self.context;
    view.drawableDepthFormat = GLKViewDrawableDepthFormat24;
    
    [self setupGL];
}

- (void)dealloc
{    
    [self tearDownGL];
    
    if ([EAGLContext currentContext] == self.context) {
        [EAGLContext setCurrentContext:nil];
    }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];

    if ([self isViewLoaded] && ([[self view] window] == nil)) {
        self.view = nil;
        
        [self tearDownGL];
        
        if ([EAGLContext currentContext] == self.context) {
            [EAGLContext setCurrentContext:nil];
        }
        self.context = nil;
    }

    // Dispose of any resources that can be recreated.
}

- (BOOL)prefersStatusBarHidden {
    return YES;
}

- (void)setupGL
{
    NSString *vertShaderPathname, *fragShaderPathname, *resPathname;
    
    [EAGLContext setCurrentContext:self.context];
    
    vertShaderPathname = [[NSBundle mainBundle] pathForResource:@"simple_vertex" ofType:@"glsl"];
    fragShaderPathname = [[NSBundle mainBundle] pathForResource:@"simple_fragment" ofType:@"glsl"];
    resPathname        = [[NSBundle mainBundle] pathForResource:@"human" ofType:@"bfres"];
    
    SimpleInit([resPathname UTF8String],[vertShaderPathname UTF8String], [fragShaderPathname UTF8String]);
}

- (void)tearDownGL
{
    SimpleDestroy();
    [EAGLContext setCurrentContext:self.context];
}

#pragma mark - GLKView and GLKViewController delegate methods

- (void)update
{
    SimpleCalc();
}

- (void)glkView:(GLKView *)view drawInRect:(CGRect)rect
{
    float scale  = [[UIScreen mainScreen] scale];
    float width  = [[UIScreen mainScreen] bounds].size.width  * scale;
    float height = [[UIScreen mainScreen] bounds].size.height * scale;
    
    SimpleDraw();
    // GLKViewが用意したフレームバッファに戻す
    [(GLKView *)self.view bindDrawable];
    SimpleCopyOut(width, height);
}

@end
