﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_DEMO_DEMOUTILITY_H_
#define NW_G3D_DEMO_DEMOUTILITY_H_

#include <nw/g3d/g3d_config.h>
#include <nw/g3d/g3d_ModelObj.h>
#include <nw/g3d/edit/g3d_IAllocator.h>

#include <cstdio>
#include <android/asset_manager.h>
#include <log.h>

namespace nw { namespace g3d { namespace fnd {

class GfxColorBuffer;
class GfxContext;

}}} // namespace nw::g3d::fnd

namespace nw { namespace g3d { namespace math {

class Mtx34;
class Vec3;

}}} // namespace nw::g3d::math

namespace nw { namespace g3d { namespace demo {

enum
{
    DEFAULT_ALIGNMENT = 4
};

void* AllocMem1(size_t size, size_t alignment = DEFAULT_ALIGNMENT);

template <typename T>
inline
T* AllocMem1(size_t size, size_t alignment = DEFAULT_ALIGNMENT)
{
    return static_cast<T*>(AllocMem1(size, alignment));
}

void FreeMem1(void* ptr);

void* AllocMem2(size_t size, size_t alignment = DEFAULT_ALIGNMENT);

template <typename T>
inline
T* AllocMem2(size_t size, size_t alignment = DEFAULT_ALIGNMENT)
{
    return static_cast<T*>(AllocMem2(size, alignment));
}

void FreeMem2(void* ptr);

typedef void* (*FuncAlloc)(size_t size, size_t alignment);
typedef void (*FuncFree)(void* ptr);

//--------------------------------------------------------------------------------------------------
// File

void  SetAssetManager(AAssetManager* mgr);
void* LoadFile(const char* path, size_t* pSize = NULL, size_t alignment = DEFAULT_ALIGNMENT);

//--------------------------------------------------------------------------------------------------
// Display

struct InitDisplayArg
{
    InitDisplayArg()
        : modeTV(GX2_TV_RENDER_720)
        , formatTV(GX2_SURFACE_FORMAT_TCS_R8_G8_B8_A8_SRGB)
        , modeDRC(GX2_DRC_SINGLE)
        , formatDRC(GX2_SURFACE_FORMAT_TCS_R8_G8_B8_A8_SRGB)
        , swapInterval(1)
    {
    }

    GX2TVRenderMode modeTV;
    GX2SurfaceFormat formatTV;
    GX2DRCMode modeDRC;
    GX2SurfaceFormat formatDRC;
    int swapInterval;
};

void InitDisplay(const InitDisplayArg& arg = InitDisplayArg());
void CopyOut(const nw::g3d::GfxColorBuffer* pColorBuffer);
void SwapScanBuffers();

}}} // namespace nw::g3d::demo

#endif // NW_G3D_DEMO_DEMOUTILITY_H_
