﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

import clr
clr.AddReference("System.Xml")
from System.Xml import *
import os

class ShaderArchive(object):
    def __init__(self):
        self.archive = None
        self.shading_models = {}

def IsFmd(x):
    return x.Extension == ".fmda" or x.Extension == ".fmdb"

def IsFsd(x):
    return x.Extension == ".fsda" or x.Extension == ".fsdb"

def PreFilter(targets):
    args = ScriptArgument.split()
    if len(args) == 0:
        print("fsv のテンプレートファイルを --argument に指定してください。")
        Result = False
        return

    fmdList = filter(IsFmd, targets)
    fsdList = filter(IsFsd, targets)

    for fmd in fmdList:
        fmd.Result = {}
        for shader_assign in fmd.Document.SelectNodes(
            "/nw4f_3dif/model/material_array/material/shader_assign"):
            shader_archive_name = shader_assign.GetAttribute("shader_archive")
            if not shader_archive_name in fmd.Result:
                # アサインされているシェーダを探す
                def FindFsd(x):
                    return x.FileNameWithoutExtension == shader_archive_name
                fsds = filter(FindFsd, fsdList)
                if len(fsds) == 0:
                    print("シェーダが見つかりませんでした。")
                    print shader_archive_name
                    Result = False
                    return
                fsd = fsds[0]
                # print "シェーダ >>> " + fsd.FilePath

                shader_archive = ShaderArchive()
                shader_archive.archive = fsd
                fmd.Result[shader_archive_name] = shader_archive

def Filter(target):
	if (not IsFmd(target)):
		return

	shader_archives = target.Result

	skinnings = []
	for shape_info in target.Document.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape/shape_info"):
		vertex_skinning_count = int(shape_info.GetAttribute("vertex_skinning_count")) + 1
		override = 0
		for skinning in skinnings:
			if skinning == vertex_skinning_count:
				override = 1
				break
		if override == 0:
			skinnings.append(vertex_skinning_count)
	skinning_choice = ""
	index = 0
	for skinning in skinnings:
		if index != 0:
			skinning_choice += ","
		skinning_choice += str(skinning)
		index += 1
	skinning_option = []
	skinning_option.append("skinning")
	skinning_option.append(skinning_choice)

	# シェーダオプション情報の収集
	for shader_assign in target.Document.SelectNodes(
		"/nw4f_3dif/model/material_array/material/shader_assign"):
		shader_archive_name = shader_assign.GetAttribute("shader_archive")
		shading_model_name = shader_assign.GetAttribute("shading_model")

		shader_archive = shader_archives[shader_archive_name]
		# shader_archive.archive により使用しているシェーダアーカイブが取得できます。

		options = []
		for shader_option in shader_assign.SelectNodes("shader_option_array/shader_option"):
			option = []
			option.append(shader_option.GetAttribute("id"))
			option.append(shader_option.GetAttribute("value"))
			options.append(option)
		options.append(skinning_option)
		if shading_model_name == "town":
			option_water = []
			option_water.append("water_world")
			option_water.append("*")
			options.append(option_water)
			option_ice = []
			option_ice.append("ice_world")
			option_ice.append("*")
			options.append(option_ice)
		if shading_model_name == "town" or shading_model_name == "basic":
			option_coord = []
			option_coord.append("coord")
			option_coord.append("*")
			options.append(option_coord)

		if shading_model_name in shader_archive.shading_models:
			shading_model = shader_archive.shading_models[shading_model_name]
			shading_model.append(options)
		else:
			shading_model = []
			shading_model.append(options)
			shader_archive.shading_models[shading_model_name] = shading_model

def PostFilter(targets):
    args = ScriptArgument.split()

    # 第一引数: fsv テンプレートファイルのパス（必須）
    fsvTemplate = args[0]

    # 第二引数: fsv 出力先ディレクトリ
    fsvOutput = ""
    if len(args) > 1:
        fsvOutput = os.path.normpath(args[1])

	# アーカイブごとにシェーダオプションを収集
	shader_archives = {}

	for target in targets:
		if (not IsFmd(target) or target.Result == None):
			continue

		for shader_archive_item in target.Result.items():
			shader_archive_name = shader_archive_item[0]
			shader_archive = shader_archive_item[1]

			if not shader_archive_name in shader_archives:
				shader_archives[shader_archive_name] = {}
			shading_models = shader_archives[shader_archive_name]

			for shading_model_item in shader_archive.shading_models.items():
				shading_model_name = shading_model_item[0]
				programs = shading_model_item[1]

				if shading_model_name in shading_models:
					# options の重複チェックは行っていない
					shading_models[shading_model_name] += programs
				else:
					shading_models[shading_model_name] = programs

	if len(shader_archives) == 0:
		return

    # アーカイブごとに fsva を作成する
	for shader_archive in shader_archives.items():
		shader_archive_name = shader_archive[0]
		shading_models = shader_archive[1]

		# fsva の書き出し
		fsv = XmlDocument()
		fsv.Load(fsvTemplate)
		shader_variation_info = fsv.SelectSingleNode(
			"/nw4f_3dif/shader_variation/shader_variation_info")
		shader_variation_info.SetAttribute("shader_archive", shader_archive_name)
		target_shader_array = fsv.SelectSingleNode(
			"/nw4f_3dif/shader_variation/target_shader_array")
		target_shader_array.RemoveChild (target_shader_array.FirstChild)

		target_shader_index = 0
		for shading_model in shading_models.items():
			shading_model_name = shading_model[0]
			programs = shading_model[1]
			target_shader = fsv.CreateElement("target_shader")
			target_shader.SetAttribute("index", str(target_shader_index))
			target_shader_index += 1
			target_shader.SetAttribute("shading_model_name", shading_model_name)
			target_shader_array.AppendChild(target_shader)

			shader_program_array = fsv.CreateElement("shader_program_array")
			target_shader.AppendChild(shader_program_array)

			shader_program_index = 0
			for options in programs:
				shader_program = fsv.CreateElement("shader_program")
				shader_program.SetAttribute("index", str(shader_program_index))
				shader_program_index += 1
				shader_program_array.AppendChild(shader_program)

				if len(options) == 0:
					continue

				option_array = fsv.CreateElement("option_array")
				shader_program.AppendChild(option_array)

				for option in options:
					id = option[0]
					choice = option[1]
					#特定の id に対する value 変更処理
					if id == "":
						pass

					AddOption(option_array, fsv.CreateElement("option"), id, choice)

				option_array.SetAttribute("length", str(option_array.ChildNodes.Count))

			shader_program_array.SetAttribute("length", str(shader_program_index))

		target_shader_array.SetAttribute("length", str(target_shader_index))

		fsvArchivePath = os.path.join(fsvOutput, os.path.join(shader_archive_name + ".fsva"))
		fsv.Save(fsvArchivePath)

def AddOption(option_array, option, id, choice):
    option.SetAttribute("index", str(option_array.ChildNodes.Count))
    option.SetAttribute("id", id)
    option.SetAttribute("choice", choice)
    option_array.AppendChild(option)
