﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#include <common.glsl>
#include <skeleton_block.glsl>
#include <view_block.glsl>

#define SKINNING            ( 0 ) // @@ id="skinning" choice="[0, 9]" type="dynamic"
#define NUM_POS             ( 1 ) // @@ id="num_pos" choice="[1, 8]" type="dynamic"

// 0: 法線無し、1: 法線有り・ブレンド無し、2:法線有り・ブレンド有り
#define NUM_NRM             ( 0 ) // @@ id="num_nrm" choice="[0, 2]" type="dynamic"
#define NUM_TAN             ( 0 ) // @@ id="num_tan" choice="[0, 2]" type="dynamic"

//--------------------------------------------------------------------------------------------------

#if NW_VERTEX_SHADER

layout(location = 0)  in ivec4  i_Index0;       // @@ id="_i0"   hint="blendindex0"
layout(location = 1)  in vec4   i_Weight0;      // @@ id="_w0"   hint="blendweight0"
layout(location = 2)  in ivec4  i_Index1;       // @@ id="_i1"   hint="blendindex1"
layout(location = 3)  in vec4   i_Weight1;      // @@ id="_w1"   hint="blendweight1"
layout(location = 4)  in vec4   i_Position0;    // @@ id="_p0"   hint="position0"
layout(location = 5)  in vec3   i_Normal0;      // @@ id="_n0"   hint="normal0"
layout(location = 6)  in vec4   i_Tangent0;     // @@ id="_t0"   hint="tangent0"
layout(location = 7)  in vec4   i_Position1;    // @@ id="_p1"   hint="position1"
layout(location = 8)  in vec3   i_Normal1;      // @@ id="_n1"   hint="normal1"
layout(location = 9)  in vec4   i_Tangent1;     // @@ id="_t1"   hint="tangent1"
layout(location = 10) in vec4   i_Position2;    // @@ id="_p2"   hint="position2"
layout(location = 11) in vec3   i_Normal2;      // @@ id="_n2"   hint="normal2"
layout(location = 12) in vec4   i_Tangent2;     // @@ id="_t2"   hint="tangent2"
layout(location = 13) in vec4   i_Position3;    // @@ id="_p3"   hint="position3"
layout(location = 14) in vec3   i_Normal3;      // @@ id="_n3"   hint="normal3"
layout(location = 15) in vec4   i_Tangent3;     // @@ id="_t3"   hint="tangent3"

#if 0 // GL 版の頂点属性数制限により未使用。

layout(location = 16)  in vec4   i_Position4;    // @@ id="_p4"   hint="position4"
layout(location = 17)  in vec3   i_Normal4;      // @@ id="_n4"   hint="normal4"
layout(location = 18)  in vec4   i_Tangent4;     // @@ id="_t4"   hint="tangent4"
layout(location = 19)  in vec4   i_Position5;    // @@ id="_p5"   hint="position5"
layout(location = 20)  in vec3   i_Normal5;      // @@ id="_n5"   hint="normal5"
layout(location = 21)  in vec4   i_Tangent5;     // @@ id="_t5"   hint="tangent5"
layout(location = 22)  in vec4   i_Position6;    // @@ id="_p6"   hint="position6"
layout(location = 23)  in vec3   i_Normal6;      // @@ id="_n6"   hint="normal6"
layout(location = 24)  in vec4   i_Tangent6;     // @@ id="_t6"   hint="tangent6"
layout(location = 25)  in vec4   i_Position7;    // @@ id="_p7"   hint="position7"
layout(location = 26)  in vec3   i_Normal7;      // @@ id="_n7"   hint="normal7"
layout(location = 27)  in vec4   i_Tangent7;     // @@ id="_t7"   hint="tangent7"

#endif

out vec3 o_Pos;

#if NUM_NRM >= 1
flat out int o_Nrm;
#endif
#if NUM_TAN >= 1
flat out int o_Tan;
#endif

#if TYPE == 0
// @@ streamout="o_Pos"
#elif TYPE == 1
// @@ streamout="o_Pos o_Nrm"
#elif TYPE == 2
// @@ streamout="o_Pos o_Nrm o_Tan"
#endif

#endif // NW_VERTEX_SHADER

//--------------------------------------------------------------------------------------------------

layout(std140) uniform Shape // @@ id="shape" type="shape"
{
    vec4 shapeMtx[3];
    int vtxSkinCount;
    int reserved0;
    int reserved1;
    int reserved2;

    // 以下はユーザ領域です。
    vec4 blendWeight[2];
};

//--------------------------------------------------------------------------------------------------

#if NW_VERTEX_SHADER

void main()
{
    vec4 pos_l = i_Position0;
    vec3 nrm_l = i_Normal0;
    vec3 tan_l = i_Tangent0.xyz;

    if (NUM_POS >= 2)
    {
        vec2 weight = blendWeight[0].xy;
        pos_l.xyz *= weight.x;
        pos_l.xyz += weight.y * i_Position1.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz *= weight.x;
            nrm_l.xyz += weight.y * i_Normal1.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz *= weight.x;
            tan_l.xyz += weight.y * i_Tangent1.xyz;
        }
    }
    if (NUM_POS >= 3)
    {
        float weight = blendWeight[0][2];
        pos_l.xyz += weight * i_Position2.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal2.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent2.xyz;
        }
    }
    if (NUM_POS >= 4)
    {
        float weight = blendWeight[0][3];
        pos_l.xyz += weight * i_Position3.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal3.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent3.xyz;
        }
    }
#if 0  // GL 版の頂点属性数制限により未使用。
    if (NUM_POS >= 5)
    {
        float weight = blendWeight[1][0];
        pos_l.xyz += weight * i_Position4.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal4.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent4.xyz;
        }
    }
    if (NUM_POS >= 6)
    {
        float weight = blendWeight[1][1];
        pos_l.xyz += weight * i_Position5.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal5.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent5.xyz;
        }
    }
    if (NUM_POS >= 7)
    {
        float weight = blendWeight[1][2];
        pos_l.xyz += weight * i_Position6.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal6.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent6.xyz;
        }
    }
    if (NUM_POS >= 8)
    {
        float weight = blendWeight[1][3];
        pos_l.xyz += weight * i_Position7.xyz;
        if (NUM_NRM >= 2)
        {
            nrm_l.xyz += weight * i_Normal7.xyz;
        }
        if (NUM_TAN >= 2)
        {
            tan_l.xyz += weight * i_Tangent7.xyz;
        }
    }
#endif

    vec4 pos_w = vec4(0, 0, 0, pos_l.w);
    vec3 nrm_w = vec3(0);
    vec3 tan_w = vec3(0);

    int skinning = SKINNING > 0 ? SKINNING - 1 : vtxSkinCount;
    if (skinning == 0)
    {
        // rigid body
        pos_w.xyz = NW_G3D_TRANSFORM_POS(shapeMtx, pos_l);
        nrm_w.xyz = NW_G3D_TRANSFORM_VEC(shapeMtx, nrm_l);
        tan_w.xyz = NW_G3D_TRANSFORM_VEC(shapeMtx, tan_l);
    }
    else if (skinning == 1)
    {
        // rigid skinning
        int offset = i_Index0.x * 3;
        pos_w.xyz = NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, pos_l);
        nrm_w.xyz = NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, nrm_l);
        tan_w.xyz = NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, tan_l);
    }
    else if (skinning <= 4)
    {
        // smooth skinning [1, 4]
        for (int i = 0; i < skinning; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, pos_l);
            nrm_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, nrm_l);
            tan_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, tan_l);
        }
    }
    else if (skinning <= 8)
    {
        // smooth skinning [5, 8]
        for (int i = 0; i < 4; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, pos_l);
            nrm_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, nrm_l);
            tan_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, tan_l);
        }
        for (int i = 4; i < skinning; ++i)
        {
            int offset = i_Index1[i - 4] * 3;
            float weight = i_Weight1[i - 4];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, pos_l);
            nrm_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, nrm_l);
            tan_w.xyz += weight * NW_G3D_TRANSFORM_VEC_OFFSET(mtxPalette, offset, tan_l);
        }
    }

    o_Pos = pos_w.xyz;

#if NUM_NRM >= 1
    nrm_w = normalize(nrm_w) * 127.0 + 0.5;
    o_Nrm = ( int(nrm_w.x) & 0xFF )
        | ( ( int(nrm_w.y) & 0xFF ) << 8 )
        | ( ( int(nrm_w.z) & 0xFF ) << 16 );
#endif
#if NUM_TAN >= 1
    tan_w = normalize(tan_w) * 127.0 + 0.5;
    o_Tan = ( int(tan_w.x) & 0xFF )
        | ( ( int(tan_w.y) & 0xFF ) << 8 )
        | ( ( int(tan_w.z) & 0xFF ) << 16 )
        | ( i_Tangent0.w > 0.0 ? int(0x7F000000) : int(0x81000000) );
#endif
}

#endif

