﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#include <common.glsl>
#include <skeleton_block.glsl>
#include <view_block.glsl>

#define SKINNING            ( 0 )       // @@ id="skinning" choice="[0, 9]" type="dynamic"

//--------------------------------------------------------------------------------------------------

#ifdef NW_VERTEX_SHADER

layout(location = 0)  in vec4   i_Position;     // @@ id="_p0"   hint="position0"
layout(location = 1)  in ivec4  i_Index0;       // @@ id="_i0"   hint="blendindex0"
layout(location = 2)  in ivec4  i_Index1;       // @@ id="_i1"   hint="blendindex1"
layout(location = 3)  in vec4   i_Weight0;      // @@ id="_w0"   hint="blendweight0"
layout(location = 4)  in vec4   i_Weight1;      // @@ id="_w1"   hint="blendweight1"

#endif // NW_VERTEX_SHADER

#if NW_FRAGMENT_SHADER

layout(location = 0)  out uvec2 o_Color;

#endif // NW_FRAGMENT_SHADER

//--------------------------------------------------------------------------------------------------

layout(std140) uniform Shapes   // @@ id="shape" type="shape"
{
    vec4 shapeMtx[3];
    int vtxSkinCount;
    int reserved0;
    int reserved1;
    int reserved2;

    // ユーザ領域にマテリアルピック用の情報をもちます。
    uint userModelPtr;
    uint matId;
};

//--------------------------------------------------------------------------------------------------

#ifdef NW_VERTEX_SHADER

void main()
{
    vec4 pos_w = vec4(0, 0, 0, 1);

    int skinning = SKINNING > 0 ? SKINNING - 1 : vtxSkinCount;
    if (skinning == 0)
    {
        // rigid body
        pos_w.xyz = NW_G3D_TRANSFORM_POS(shapeMtx, i_Position);
    }
    else if (skinning == 1)
    {
        // rigid skinning
        int offset = i_Index0.x * 3;
        pos_w.xyz = NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
    }
    else if (skinning <= 4)
    {
        // smooth skinning [1, 4]
        for (int i = 0; i < skinning; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
    }
    else if (skinning <= 8)
    {
        // smooth skinning [5, 8]
        for (int i = 0; i < 4; ++i)
        {
            int offset = i_Index0[i] * 3;
            float weight = i_Weight0[i];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
        for (int i = 4; i < skinning; ++i)
        {
            int offset = i_Index1[i - 4] * 3;
            float weight = i_Weight1[i - 4];
            pos_w.xyz += weight * NW_G3D_TRANSFORM_POS_OFFSET(mtxPalette, offset, i_Position);
        }
    }

    vec4 pos_v = vec4(NW_G3D_TRANSFORM_POS(cameraMtx, pos_w), 1);
    gl_Position = NW_G3D_PROJECT(projMtx, pos_v);
}

#endif // NW_VERTEX_SHADER

//--------------------------------------------------------------------------------------------------

#ifdef NW_FRAGMENT_SHADER

void main()
{
    o_Color.x = userModelPtr;
    o_Color.y = matId;
}

#endif // NW_FRAGMENT_SHADER
