﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 330

out vec4 uv_coef;
out vec4 color;

#define BIT_X ( 11 )
#define BIT_Y ( 10 )
#define BIT_U ( 1 )
#define BIT_V ( 7 )
#define BIT_B ( 1 )
#define BIT_G ( 1 )
#define BIT_R ( 1 )
#define SHIFT_X ( 0 )
#define SHIFT_Y ( SHIFT_X + BIT_X )
#define SHIFT_U ( SHIFT_Y + BIT_Y )
#define SHIFT_V ( SHIFT_U + BIT_U )
#define SHIFT_B ( SHIFT_V + BIT_V )
#define SHIFT_G ( SHIFT_B + BIT_B )
#define SHIFT_R ( SHIFT_G + BIT_G )
#define MASK_X ( (1 << BIT_X) - 1 )
#define MASK_Y ( (1 << BIT_Y) - 1 )
#define MASK_U ( (1 << BIT_U) - 1 )
#define MASK_V ( (1 << BIT_V) - 1 )
#define SHIFT_A ( SHIFT_B )
#define MASK_A ( 7 )
#define TEX_U ( 8 )

void main()
{
    gl_Position.x = float((gl_VertexID >> SHIFT_X) & MASK_X) / MASK_X * 2 - 1;
    gl_Position.y = 1 - float((gl_VertexID >> SHIFT_Y) & MASK_Y) / MASK_Y * 2;
    gl_Position.z = 0;
    gl_Position.w = 1;
    uv_coef.x = float((gl_VertexID >> SHIFT_U) & MASK_U);
    uv_coef.y = float((gl_VertexID >> SHIFT_V) & MASK_V) / (1 << BIT_V);
    color.r = float((gl_VertexID >> SHIFT_R) & 0x1);
    color.g = float((gl_VertexID >> SHIFT_G) & 0x1);
    color.b = float((gl_VertexID >> SHIFT_B) & 0x1);
    color.a = float((gl_VertexID >> SHIFT_A) & MASK_A) / MASK_A;
    if (uv_coef.y < 0.25)
    {
        // Shape
        // color.rgb はテクスチャから引くので使わない。
        uv_coef.x = uv_coef.x * 0.5 + 0.25; // ボーダーにかからないよう寄せる。
        uv_coef.zw = vec2(1, 0);
    }
    else
    {
        // Font
        // color.a はテクスチャから引くので使わない。
        uv_coef.x -= float(0.5 / TEX_U); // 半テクセルずらす。
        uv_coef.zw = vec2(0, 1);
    }
}
