@echo off

set ToolRoot=%~1
set TargetDir=%~2
set Output=%~3
set ShdrCvtrOptions=%~4

call "%~dp0convert_env.bat" "%ToolRoot%"

set TOWN_DIR=%ROOT%\town
set TOWN_BUILD_FSV=%TOWN_DIR%\TownBuildFsv.py
set FSV_TEMPLATE=%TOWN_DIR%\Template.fsva

set COMMAND_FILE=%TargetDir%\command

del /q "%COMMAND_FILE%"

"%FILTER%" --enable-extension="fmdb,fsdb" --script="%TOWN_BUILD_FSV%" --argument="%FSV_TEMPLATE% %TargetDir% " "%TargetDir%" "%ROOT%\shader\town.fsdb"
if errorlevel 1 exit /b 1

"%SHDRCVTR%" %SHDRCVTR_OPTIONS% %ShdrCvtrOptions% --force-variation --output="%TargetDir%\town.bfsha" "%ROOT%\shader\town.fsdb" "%TargetDir%\town.fsva"
if errorlevel 1 exit /b 1

echo --output="%Output%" >> "%COMMAND_FILE%"
for %%f in (%TargetDir%\*.f??b) do echo "%%f" >> "%COMMAND_FILE%"
for %%f in (%TargetDir%\textures\*.ftxb) do echo "%%f" >> "%COMMAND_FILE%"
echo --external-file="%TargetDir%\town.bfsha" >> "%COMMAND_FILE%"

"%BINCVTR%" --args-file="%COMMAND_FILE%"
if errorlevel 1 exit /b 1

del /q "%COMMAND_FILE%"
del /q "%TargetDir%\town.fsva"
del /q "%TargetDir%\town.bfsha"

exit /b 0
