﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.Spy
{
    public static class VersionUtility
    {
        /// <summary>
        /// Minor が一つ大きいバージョンを取得します。
        /// バージョン比較で Build と Revision を無視したい場合に使います。
        /// <code>
        /// Assert(minVersion &lt;= version &amp;&amp; version &lt; maxVersion.IncrementMinor());
        /// </code>
        /// </summary>
        /// <param name="version">バージョンです。</param>
        /// <returns>Minor が一つ大きいバージョンです。</returns>
        public static Version IncrementMinor(this Version version)
        {
            return new Version(version.Major, version.Minor + 1, version.Build, version.Revision);
        }
    }
}
