﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Threading;
using System.Windows.Threading;

namespace NintendoWare.Spy
{
    /// <summary>
    /// アクションを非同期に実行します。
    /// すでにリクエストされているときは何もしません。
    /// つまり複数のリクエストは一つにまとめます。
    /// </summary>
    public sealed class MergedRequestDispatcher : DispatcherObject
    {
        private int _isProcessing;

        public MergedRequestDispatcher()
        {
        }

        /// <summary>
        /// アクションの実行をリクエストします。
        /// すでにリクエスト済みであれば何もしません。
        /// </summary>
        /// <param name="action"></param>
        /// <param name="priority"></param>
        public void Request(Action action, DispatcherPriority priority = DispatcherPriority.Normal)
        {
            Ensure.Argument.NotNull(action, nameof(action));

            if (Interlocked.Exchange(ref _isProcessing, 1) == 0)
            {
                this.Dispatcher.InvokeAsync(
                    () =>
                    {
                        Interlocked.Exchange(ref _isProcessing, 0);
                        action();
                    },
                    priority);
            }
        }
    }
}
