﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;
using System.ComponentModel;
using System.Globalization;

namespace NintendoWare.Spy
{
    public sealed class SpyTimeTypeConverter : TypeConverter
    {
        private static readonly char[] Splitter = new char[] { ',' };

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
        {
            if (sourceType == typeof(string))
            {
                return true;
            }

            return base.CanConvertFrom(context, sourceType);
        }

        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
        {
            if (destinationType == typeof(string))
            {
                return true;
            }

            return base.CanConvertTo(context, destinationType);
        }

        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value)
        {
            if (value is string)
            {
                var source = (string)value;
                var values = source.Split(Splitter, 3);
                Ensure.Operation.NotNull(values);
                Ensure.Operation.AreEqual(values.Length, 3);
                return new SpyTime(
                    new SpyGlobalTime(long.Parse(values[0])),
                    new Frame(long.Parse(values[1])),
                    new Frame(long.Parse(values[2])));
            }

            return base.ConvertFrom(context, culture, value);
        }

        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType)
        {
            if (destinationType == typeof(string))
            {
                var time = (SpyTime)value;
                return string.Join(",", time.Timestamp.ToString(), time.AppFrame.ToString(), time.AudioFrame.ToString());
            }

            return base.ConvertTo(context, culture, value, destinationType);
        }
    }
}
