﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy
{
    /// <summary>
    /// Spy データの読み込みをサポートします。
    /// </summary>
    internal interface ISpyDataReader
    {
        /// <summary>
        /// 指定データ ID、データブロック ID のデータを読み込みます。
        /// </summary>
        /// <param name="dataName">データ名を指定します。</param>
        /// <param name="dataBlockID">データブロック ID を指定します。</param>
        /// <returns>読み込んだデータブロックを返します。</returns>
        SpyDataBlock ReadDataBlock(string dataName, long dataBlockID);

        /// <summary>
        /// リトルエンディアンかどうかを取得します。
        /// </summary>
        bool? IsLittleEndian { get; }
    }
}
