﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.Generic;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// Spy の接続先情報を格納します。
    /// （※注意）
    /// この情報は、「提供元 ⇒ 観測者」への OneWay です。
    /// ここに新しい値を設定したとしても、その値が情報の提供元に反映されません。
    /// </summary>
    public class SpyConnectionInfo : ObservableObject
    {
        private IEnumerable<ConnectionInfo> _connectionInfos;
        private ConnectionInfo _selectedConnectionInfo;

        /// <summary>
        /// Spy の接続先情報の列挙子を取得または設定します。
        /// </summary>
        public IEnumerable<ConnectionInfo> ConnectionInfos
        {
            get { return _connectionInfos; }
            set { this.SetPropertyValue(ref _connectionInfos, value); }
        }

        /// <summary>
        /// Spy で選択中の接続先情報を取得または設定します。
        /// </summary>
        public ConnectionInfo SelectedConnectionInfo
        {
            get { return _selectedConnectionInfo; }
            set { this.SetPropertyValue(ref _selectedConnectionInfo, value); }
        }
    }
}
