﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Media3D;

namespace NintendoWare.Spy.Windows
{
    public static class VisualTreeUtility
    {
        /// <summary>
        /// Visual Tree の子ノードを得ます。
        /// </summary>
        /// <param name="d"></param>
        /// <returns></returns>
        public static IEnumerable<DependencyObject> EnumerateChildren(DependencyObject d)
        {
            Ensure.Argument.NotNull(d);
            Ensure.Argument.True(d is Visual || d is Visual3D);

            var numChildren = VisualTreeHelper.GetChildrenCount(d);
            for (int i = 0; i < numChildren; i++)
            {
                yield return VisualTreeHelper.GetChild(d, i);
            }
        }

        /// <summary>
        /// Visual Tree の子孫ノードのなかで指定したクラスの最初のノードを見つけます。
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="d"></param>
        /// <param name="maxDepth"></param>
        /// <returns></returns>
        public static T FindFirstDescendant<T>(DependencyObject d, int maxDepth = 1)
            where T : DependencyObject
        {
            Ensure.Argument.NotNull(d);
            Ensure.Argument.True(d is Visual || d is Visual3D);

            foreach (var child in EnumerateChildren(d))
            {
                if (child is T)
                {
                    return (T)child;
                }
                else if (maxDepth > 1)
                {
                    var result = FindFirstDescendant<T>(child, maxDepth - 1);
                    if (result != null)
                    {
                        return result;
                    }
                }
            }

            return null;
        }
    }
}
