﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows.Primitives
{
    public class PlotGrid : Control
    {
        public static readonly DependencyProperty OriginXProperty
            = DependencyProperty.Register(
                nameof(OriginX),
                typeof(double),
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(double.NaN));

        public static readonly DependencyProperty ScaleXProperty
            = DependencyProperty.Register(
                nameof(ScaleX),
                typeof(double),
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(double.NaN));

        /// <summary>
        /// グリッドの間隔を示す依存プロパティです。
        /// </summary>
        public static readonly DependencyProperty GridFrequencyProperty =
            DependencyProperty.Register(
                nameof(GridFrequency),
                typeof(double),
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(100.0));

        public static readonly DependencyProperty LabelTemplateProperty =
            DependencyProperty.Register(
                nameof(LabelTemplate),
                typeof(DataTemplate),
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(null));

        public static readonly DependencyProperty GridStrokeProperty =
            DependencyProperty.Register(
                nameof(GridStroke),
                typeof(Brush),
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(Brushes.DimGray));

        //----------------------------------------------------------------------------------

        static PlotGrid()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(PlotGrid),
                new FrameworkPropertyMetadata(typeof(PlotGrid)));
        }

        public double OriginX
        {
            get { return (double)this.GetValue(OriginXProperty); }
            set { this.SetValue(OriginXProperty, value); }
        }

        public double ScaleX
        {
            get { return (double)this.GetValue(ScaleXProperty); }
            set { this.SetValue(ScaleXProperty, value); }
        }

        /// <summary>
        /// 保証すべきグリッド間隔(ピクセル)です。
        /// 実際のグリッド間隔はこの値以上になります。
        /// </summary>
        public double GridFrequency
        {
            get { return (double)this.GetValue(GridFrequencyProperty); }
            set { this.SetValue(GridFrequencyProperty, value); }
        }

        public DataTemplate LabelTemplate
        {
            get { return (DataTemplate)this.GetValue(LabelTemplateProperty); }
            set { this.SetValue(LabelTemplateProperty, value); }
        }

        public Brush GridStroke
        {
            get { return (Brush)this.GetValue(GridStrokeProperty); }
            set { this.SetValue(GridStrokeProperty, value); }
        }

        private double ValidatedOriginX
        {
            get { return PlotCanvas.GetValidatedOriginX(this.OriginX); }
        }

        private double ValidatedScaleX
        {
            get { return PlotCanvas.GetValidatedScaleX(this.ScaleX); }
        }

        private static PlotGrid Self(DependencyObject d)
        {
            return (PlotGrid)d;
        }
    }
}
