﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;

namespace NintendoWare.Spy.Windows.Primitives
{
    /// <summary>
    /// カレントフレームを表示するコントロールです。
    /// </summary>
    public sealed class PlotCurrentLine : Control
    {
        public static readonly DependencyProperty OriginXProperty
            = DependencyProperty.Register(
                nameof(OriginX),
                typeof(double),
                typeof(PlotCurrentLine),
                new FrameworkPropertyMetadata(double.NaN));

        public static readonly DependencyProperty ScaleXProperty
            = DependencyProperty.Register(
                nameof(ScaleX),
                typeof(double),
                typeof(PlotCurrentLine),
                new FrameworkPropertyMetadata(double.NaN));

        public static readonly DependencyProperty CurrentXProperty
            = DependencyProperty.Register(
                nameof(CurrentX),
                typeof(double),
                typeof(PlotCurrentLine),
                new FrameworkPropertyMetadata(0.0, (d, e) => Self(d).OnCurrentXChanged(e)));

        //----------------------------------------------------------------------

        public double OriginX
        {
            get { return (double)this.GetValue(OriginXProperty); }
            set { this.SetValue(OriginXProperty, value); }
        }

        public double ScaleX
        {
            get { return (double)this.GetValue(ScaleXProperty); }
            set { this.SetValue(ScaleXProperty, value); }
        }

        /// <summary>
        /// カレントラインのX座標です。
        /// </summary>
        public double CurrentX
        {
            get { return (double)this.GetValue(CurrentXProperty); }
            set { this.SetValue(CurrentXProperty, value); }
        }

        //----------------------------------------------------------------------

        static PlotCurrentLine()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(PlotCurrentLine),
                new FrameworkPropertyMetadata(typeof(PlotCurrentLine)));
        }

        private void OnCurrentXChanged(DependencyPropertyChangedEventArgs e)
        {
        }

        private static PlotCurrentLine Self(DependencyObject d)
        {
            return (PlotCurrentLine)d;
        }
    }
}
