﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows;

namespace NintendoWare.Spy.Windows.Interactivity
{
    public enum DialogResult
    {
        Invalid = 0,
        None,
        OK,
        Cancel,
    }

    public static class DialogCloser
    {
        public static readonly DependencyProperty DialogResultProperty = DependencyProperty.RegisterAttached(
            "DialogResult",
            typeof(DialogResult),
            typeof(DialogCloser),
            new FrameworkPropertyMetadata(DialogResult.Invalid, FrameworkPropertyMetadataOptions.BindsTwoWayByDefault, OnDialogResultChanged));

        //-----------------------------------------------------------------

        public static DialogResult GetDialogResult(Window target)
        {
            return (DialogResult)target.GetValue(DialogResultProperty);
        }

        public static void SetDialogResult(Window target, DialogResult value)
        {
            target.SetValue(DialogResultProperty, value);
        }

        private static void OnDialogResultChanged(
            DependencyObject d,
            DependencyPropertyChangedEventArgs e)
        {
            var target = (Window)d;

            var newResult = (DialogResult)e.NewValue;

            if (newResult == DialogResult.Invalid)
            {
                return;
            }

            switch (newResult)
            {
                case DialogResult.OK:
                    target.DialogResult = true;
                    return;

                case DialogResult.Cancel:
                    target.DialogResult = false;
                    return;

                case DialogResult.None:
                    target.DialogResult = null;
                    return;
            }

            throw new NotImplementedException();
        }
    }
}
