﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Settings;
using System;
using System.Globalization;
using System.Windows;
using System.Windows.Data;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// bool を WaveVisibility に変換します。
    /// </summary>
    [ValueConversion(typeof(bool), typeof(WaveVisibility))]
    [ValueConversion(typeof(WaveVisibility), typeof(bool))]
    public sealed class Bool2WaveVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            WaveVisibility trueValue = WaveVisibility.None;

            if (parameter is WaveVisibility)
            {
                trueValue = (WaveVisibility)parameter;
            }

            if (value is bool)
            {
                return (bool)value ? trueValue : WaveVisibility.None;
            }
            else if (value is WaveVisibility)
            {
                if ((WaveVisibility)value == trueValue)
                {
                    return true;
                }
                else if ((WaveVisibility)value == WaveVisibility.None)
                {
                    return false;
                }
            }

            return DependencyProperty.UnsetValue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return this.Convert(value, targetType, parameter, culture);
        }
    }
}
