﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System;
using System.IO;
using System.Reflection;

namespace NintendoWare.Spy.Settings
{
    public sealed class ApplicationSettings : ObservableObject
    {
        private const string DefaultOutputDirectoryName = "./Logs";

        //-----------------------------------------------------------------

        private string _outputDirectoryPath;
        private string _playbackDeviceName;
        private TimeSpan _updateInterval = TimeSpan.FromMilliseconds(30);
        private SpyTimeUnit _timeUnit = SpyTimeUnit.Timestamp;

        //-----------------------------------------------------------------

        public ApplicationSettings()
        {
            _outputDirectoryPath = DefaultOutputDirectoryName;
        }

        //-----------------------------------------------------------------

        public string OutputDirectoryPath
        {
            get { return _outputDirectoryPath; }
            set { this.SetPropertyValue(ref _outputDirectoryPath, value); }
        }

        public string PlaybackDeviceName
        {
            get { return _playbackDeviceName; }
            set { this.SetPropertyValue(ref _playbackDeviceName, value); }
        }

        public TimeSpan UpdateInterval
        {
            get { return _updateInterval; }
            set { this.SetPropertyValue(ref _updateInterval, value); }
        }

        public SpyTimeUnit TimeUnit
        {
            get { return _timeUnit; }
            set { this.SetPropertyValue(ref _timeUnit, value); }
        }

        //-----------------------------------------------------------------

        public string GetAbsoluteOutputDirectoryPath()
        {
            return PathUtility.MakeAbsolutePath(
                this.OutputDirectoryPath,
                Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));
        }

        public void SetAbsoluteOutputDirectoryPath(string relativePath)
        {
            this.OutputDirectoryPath = PathUtility.MakeRelativePath(
                relativePath,
                Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));
        }
    }
}
