﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Windows;
using System.Collections.Generic;
using System.ComponentModel.Composition;

namespace NintendoWare.Spy.Plugins
{
    /// <summary>
    /// Spy パネルプラグインです。
    /// Spy データからパネルを作成するプレゼンターをフレームワークに注入します。
    /// </summary>
    [InheritedExport(typeof(SpyPanelPlugin))]
    public abstract class SpyPanelPlugin
    {
        public static class PlatformNames
        {
            public const string All = "all";
            public const string AllForNintendoSdk = "all-for-NintendoSDK";
        }

        /// <summary>
        /// パネル ID を取得します。
        /// </summary>
        public abstract string PanelID { get; }

        /// <summary>
        /// ローカライズされたタイトルを取得します。
        /// </summary>
        public abstract string PanelTitle { get; }

        /// <summary>
        /// 必要な Spy データ名の列挙子を取得します。
        /// </summary>
        public abstract IEnumerable<string> RequiredSpyDataNames { get; }

        /// <summary>
        /// サポートするプラットフォームの列挙子を取得します。
        /// </summary>
        public virtual IEnumerable<string> SupportedPlatforms
        {
            get
            {
                yield return PlatformNames.AllForNintendoSdk;
            }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パネルを作成する Spy パネルプレゼンターを生成します。
        /// </summary>
        /// <returns>生成した Spy パネルプレゼンターを返します。</returns>
        public SpyPanelPresenter CreatePresenter()
        {
            var result = this.CreatePresenterInstance();

            if (result == null)
            {
                return null;
            }

            result.RequiredSpyDataNames = this.RequiredSpyDataNames;
            result.SupportedPlatforms = this.SupportedPlatforms;

            return result;
        }

        /// <summary>
        /// パネルを作成する Spy パネルプレゼンターを生成します。
        /// </summary>
        /// <returns>生成した Spy パネルプレゼンターを返します。</returns>
        protected abstract SpyPanelPresenter CreatePresenterInstance();
    }
}
